/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.bm.core.BmUriUtil;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bsl.model.SourceObjectLinkProvider;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.translator.IComputedNameTranslationService;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SourceObjectLinkProviderComputedSFeatureProvider
implements IComputedStringFeatureTranslationProvider {
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private IComputedNameService computedNameService;
    @Inject
    private IComputedNameTranslationService computedNameTranslationService;

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        EObject source = this.getSource((SourceObjectLinkProvider)object);
        if (source.eClass().getFeatureID(stringFeature.getEFeature()) != -1) {
            return this.computedNameService.isComputedString(source, stringFeature);
        }
        return false;
    }

    public boolean isSupported(EObject object) {
        return object instanceof SourceObjectLinkProvider;
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        EObject source = this.getSource((SourceObjectLinkProvider)object);
        if (source.eClass().getFeatureID(stringFeature.getEFeature()) != -1) {
            return this.computedNameTranslationService.computeTranslatedString(source, stringFeature, translationProvider, language);
        }
        return null;
    }

    private EObject getSource(SourceObjectLinkProvider object) {
        URI uri = object.getSourceUri();
        IBmModel model = this.modelManager.getModel(uri);
        if (BmUriUtil.isBmUri((URI)uri)) {
            IBmTransaction transaction = model.getEngine().getCurrentTransaction();
            boolean isNewTransaction = false;
            if (transaction == null) {
                transaction = model.getEngine().beginReadOnlyTransaction(false);
                isNewTransaction = true;
            }
            try {
                IBmObject iBmObject = transaction.getObjectByUri(uri);
                return iBmObject;
            }
            finally {
                if (isNewTransaction) {
                    transaction.commit();
                }
            }
        }
        EObject source = model.getEngine().resolve(uri, EcorePackage.Literals.EOBJECT);
        if (source != null && source.eIsProxy()) {
            Configuration context = this.configurationProvider.getConfiguration(uri);
            source = EcoreUtil.resolve((EObject)source, (EObject)context);
        }
        return source;
    }
}

