/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.model.BslFactory;
import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.DeclareStatement;
import com._1c.g5.v8.dt.bsl.model.ExplicitVariable;
import com._1c.g5.v8.dt.bsl.model.FormalParam;
import com._1c.g5.v8.dt.bsl.model.ImplicitVariable;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.model.VariablesScopeSpec;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.Method;
import com._1c.g5.v8.dt.mcore.ParamSet;
import com._1c.g5.v8.dt.mcore.Parameter;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.BslGrammarTokens;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.translator.ModuleContextDefProvider;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.bsl.translator.VariableDuplicatesResolveLevel;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IScopedVariableTranslationStorageService;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.e1c.langtool.v8.dt.translator.NamedElementNameProvider;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class VariableNameProvider
extends NamedElementNameProvider {
    private static final String VAR_MASK = "Var_";
    private static final String VAR_MASK_TEMPLATE = "Var_{0}";
    private static final String VAR_MASK_DUPLICATION_TEMPLATE = "Var_{0}_{1}";
    private static final String VAR_MASK_TEMPLATE_RU = "\u041f\u0435\u0440\u0435\u043c_{0}";
    private static final String VAR_MASK_DUPLICATION_TEMPLATE_RU = "\u041f\u0435\u0440\u0435\u043c_{0}_{1}";
    private final BslGrammarTokens grammarTokens;
    private final ModuleContextDefProvider moduleContextDefProvider;
    private final BslPreferences preferences;
    private final IResourceLookup resourceLookup;
    private final IScopeProvider bslScope;
    private final INamedEObjectNameProvider namedEObjectNameProvider;
    private final IScopedVariableTranslationStorageService scopedVariableTranslationStorageService;

    @Inject
    public VariableNameProvider(IScopeProvider bslScope, ModuleContextDefProvider moduleContextDefProvider, BslGrammarTokens grammarTokens, BslPreferences preferences, IResourceLookup resourceLookup, INamedEObjectNameProvider namedEObjectNameProvider, IScopedVariableTranslationStorageService scopedVariableTranslationStorage) {
        this.bslScope = bslScope;
        this.moduleContextDefProvider = moduleContextDefProvider;
        this.grammarTokens = grammarTokens;
        this.preferences = preferences;
        this.resourceLookup = resourceLookup;
        this.namedEObjectNameProvider = namedEObjectNameProvider;
        this.scopedVariableTranslationStorageService = scopedVariableTranslationStorage;
    }

    public Collection<EClass> getSupportEClass() {
        return List.of(BslPackage.Literals.VARIABLE, BslPackage.Literals.FORMAL_PARAM);
    }

    public Collection<EClass> orderBeforeEClass() {
        return List.of(McorePackage.Literals.NAMED_ELEMENT);
    }

    public int order() {
        return 1000;
    }

    public Pair<String, String> getTranslatedName(EObject object, IProjectTranslationProvider translationProvider) {
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            String name = variable.getName();
            Provider provider = () -> {
                String translation = null;
                translation = variable instanceof FormalParam ? this.getReplaceText((FormalParam)variable, translationProvider) : this.getReplaceText(variable, translationProvider);
                if (StringUtils.isNullOrEmpty((String)translation)) {
                    translation = name;
                }
                return translation;
            };
            ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
            URI objectUri = EcoreUtil.getURI((EObject)variable);
            String translation = cache.getTranslation(objectUri, provider);
            return new Pair((Object)name, (Object)translation);
        }
        return null;
    }

    private String getReplaceText(Variable object, IProjectTranslationProvider translationProvider) {
        if (!translationProvider.getProject().isChangeDefaultLanguage()) {
            return null;
        }
        boolean isRu = translationProvider.getProject().getScriptVariant() == ScriptVariant.RUSSIAN;
        String replace = null;
        Pair translation = super.getTranslatedName((EObject)object, translationProvider);
        if (translation != null) {
            replace = (String)translation.getValue();
        }
        TranslatorProperties translationProperties = this.getTranslatorProperties((EObject)object);
        if ((StringUtils.isNullOrEmpty((String)replace) || object.getName().equalsIgnoreCase(replace)) && object instanceof ImplicitVariable && translationProperties.maskImplicitVariables()) {
            String implicitVariableCounter = this.getCurrentImplicitVariableCounter((EObject)object);
            replace = MessageFormat.format(isRu ? VAR_MASK_TEMPLATE_RU : VAR_MASK_TEMPLATE, implicitVariableCounter);
            ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
            cache.putTranslation(EcoreUtil.getURI((EObject)object), replace);
        } else if (StringUtils.isNotEmpty((String)replace) && !object.getName().equalsIgnoreCase(replace) && (this.grammarTokens.getKeyword(replace, false) != null || this.grammarTokens.getKeyword(replace, true) != null)) {
            if (this.needCheckKeywordsPropertiesTranslation(translationProperties)) {
                replace = MessageFormat.format(isRu ? VAR_MASK_TEMPLATE_RU : VAR_MASK_TEMPLATE, replace);
            }
            ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
            cache.putTranslation(EcoreUtil.getURI((EObject)object), replace);
        } else if (StringUtils.isNotEmpty((String)replace) && !object.getName().equalsIgnoreCase(replace)) {
            IEObjectDescription elem;
            VariablesScopeSpec spec = BslFactory.eINSTANCE.createVariablesScopeSpec();
            com._1c.g5.v8.dt.bsl.model.Method method = (com._1c.g5.v8.dt.bsl.model.Method)EcoreUtil2.getContainerOfType((EObject)object, com._1c.g5.v8.dt.bsl.model.Method.class);
            String methodName = "";
            if (method != null) {
                methodName = method.getUniqueName();
            }
            String variableName = object.getName();
            Module module = (Module)object.eResource().getContents().get(0);
            spec.setModule(module);
            spec.setMethod(method);
            Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)object, Environmental.class);
            spec.setEnvironments(environmental.environments());
            IScope scope = this.bslScope.getScope((EObject)spec, BslPackage.Literals.VARIABLES_SCOPE_SPEC__VARIABLE_REF);
            if (this.needCheckKeywordsPropertiesTranslation(translationProperties) && (elem = scope.getSingleElement(QualifiedName.create((String)replace))) != null) {
                replace = MessageFormat.format(isRu ? VAR_MASK_TEMPLATE_RU : VAR_MASK_TEMPLATE, replace);
                this.scopedVariableTranslationStorageService.putTranslation(module.getUniqueName(), methodName, replace, variableName);
            }
            if (this.needCheckAllPropertiesTranslation(translationProperties)) {
                replace = this.getReplaceText(object, replace, scope, isRu, module.getUniqueName(), methodName, translationProvider, this.scopedVariableTranslationStorageService);
            } else if (this.needCheckKeywordsPropertiesTranslation(translationProperties) && this.scopedVariableTranslationStorageService.hasMultipleTranslation(module.getUniqueName(), methodName, replace, variableName)) {
                replace = this.formatDuplicatedTranslation(object, replace, isRu, module.getUniqueName(), methodName, variableName, this.scopedVariableTranslationStorageService);
            }
            this.scopedVariableTranslationStorageService.putTranslation(module.getUniqueName(), methodName, replace, variableName);
        }
        return replace;
    }

    private boolean needCheckKeywordsPropertiesTranslation(TranslatorProperties translationProperties) {
        return translationProperties.getCheckVariableDuplicatesResolveLevel().equals((Object)VariableDuplicatesResolveLevel.CHECK_KEYWORDS) || translationProperties.getCheckVariableDuplicatesResolveLevel().equals((Object)VariableDuplicatesResolveLevel.CHECK_ALL_PROPERTIES);
    }

    private boolean needCheckAllPropertiesTranslation(TranslatorProperties translationProperties) {
        return translationProperties.getCheckVariableDuplicatesResolveLevel().equals((Object)VariableDuplicatesResolveLevel.CHECK_ALL_PROPERTIES);
    }

    private String getReplaceText(Variable object, String replace, IScope scope, boolean isRu, String moduleName, String methodName, IProjectTranslationProvider translationProvider, IScopedVariableTranslationStorageService moduleStorage) {
        String name = object.getName();
        URI variableUri = EcoreUtil.getURI((EObject)object);
        for (IEObjectDescription item : scope.getAllElements()) {
            String itemTranslation;
            Pair translation;
            URI uri = item.getEObjectURI();
            if (uri.equals(variableUri)) continue;
            if (moduleStorage.hasMultipleTranslation(moduleName, methodName, replace, name)) {
                return this.formatDuplicatedTranslation(object, replace, isRu, moduleName, methodName, name, moduleStorage);
            }
            EObject source = item.getEObjectOrProxy();
            if (source.eIsProxy()) {
                source = EcoreUtil.resolve((EObject)source, (EObject)object);
            }
            if (source instanceof DerivedProperty) {
                EObject proxySource = (EObject)source.eGet((EStructuralFeature)McorePackage.Literals.DERIVED_PROPERTY__SOURCE, false);
                if (proxySource != null && moduleStorage.hasMultipleTranslation(moduleName, methodName, replace, name)) {
                    return this.formatDuplicatedTranslation(object, replace, isRu, moduleName, methodName, name, moduleStorage);
                }
                source = ((DerivedProperty)source).getSource();
            }
            if ((translation = this.namedEObjectNameProvider.getTranslatedName(source, translationProvider)) == null || name.equalsIgnoreCase((String)translation.getKey()) || !StringUtils.isNotEmpty((String)(itemTranslation = (String)translation.getValue())) || !itemTranslation.equalsIgnoreCase(replace)) continue;
            return this.formatDuplicatedTranslation(object, replace, isRu, moduleName, methodName, name, moduleStorage);
        }
        return replace;
    }

    private String formatDuplicatedTranslation(Variable object, String replace, boolean isRu, String moduleName, String methodName, String variableName, IScopedVariableTranslationStorageService moduleStorage) {
        String counter = this.getCurrentImplicitVariableCounter((EObject)object);
        replace = replace.replaceFirst(VAR_MASK, "");
        replace = MessageFormat.format(isRu ? VAR_MASK_DUPLICATION_TEMPLATE_RU : VAR_MASK_DUPLICATION_TEMPLATE, counter, replace);
        moduleStorage.putTranslation(moduleName, methodName, replace, variableName);
        return replace;
    }

    private String getReplaceText(FormalParam object, IProjectTranslationProvider translationProvider) {
        if (!translationProvider.getProject().isChangeDefaultLanguage()) {
            return null;
        }
        com._1c.g5.v8.dt.bsl.model.Method method = (com._1c.g5.v8.dt.bsl.model.Method)EcoreUtil2.getContainerOfType((EObject)object, com._1c.g5.v8.dt.bsl.model.Method.class);
        String name = method.getName();
        Optional<Method> methodCd = this.moduleContextDefProvider.getContextDef((EObject)method).allMethods().stream().filter(m -> m.getName().equalsIgnoreCase(name)).findFirst();
        if (methodCd.isPresent() && !method.getFormalParams().isEmpty()) {
            int index = method.getFormalParams().indexOf((Object)object);
            ParamSet paramSet = methodCd.get().actualParamSet(method.getFormalParams().size());
            if (index > -1 && paramSet != null && paramSet.getParams().size() > index) {
                Parameter param = (Parameter)paramSet.getParams().get(index);
                URI paramUri = EcoreUtil.getURI((EObject)param);
                ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
                return cache.getTranslation(paramUri, () -> this.getReplaceText((Variable)object, translationProvider));
            }
        }
        return this.getReplaceText((Variable)object, translationProvider);
    }

    private TranslatorProperties getTranslatorProperties(EObject object) {
        IProject project = this.resourceLookup.getProject(object);
        return this.preferences.getTranslatorProperties(project);
    }

    private String getCurrentImplicitVariableCounter(EObject object) {
        Resource resource = object.eResource();
        ImplicitVariableCounterAdapter adapter = (ImplicitVariableCounterAdapter)EcoreUtil.getExistingAdapter((Notifier)resource, ImplicitVariableCounterAdapter.class);
        if (adapter == null) {
            adapter = new ImplicitVariableCounterAdapter();
            resource.eAdapters().add((Object)adapter);
            adapter.compute(object);
        }
        return Integer.toString(adapter.get(object));
    }

    private final class ImplicitVariableCounterAdapter
    extends AdapterImpl {
        private final Map<URI, Integer> order = new ConcurrentHashMap<URI, Integer>();
        private final AtomicInteger implicitVariableCounter = new AtomicInteger();

        private ImplicitVariableCounterAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type != null && type == ((Object)((Object)this)).getClass();
        }

        public int get(EObject object) {
            URI uri = EcoreUtil.getURI((EObject)object);
            if (uri == null || !uri.hasFragment()) {
                return 0;
            }
            return this.order.computeIfAbsent(uri, k -> this.implicitVariableCounter.incrementAndGet());
        }

        public synchronized void compute(EObject object) {
            URI uri;
            this.order.clear();
            this.implicitVariableCounter.set(0);
            Module module = (Module)object.eResource().getContents().get(0);
            for (DeclareStatement statement : module.allDeclareStatements()) {
                for (ExplicitVariable explVariable : statement.getVariables()) {
                    uri = EcoreUtil.getURI((EObject)explVariable);
                    if (uri == null || !uri.hasFragment()) continue;
                    this.order.put(uri, this.implicitVariableCounter.incrementAndGet());
                }
            }
            for (com._1c.g5.v8.dt.bsl.model.Method method : module.allMethods()) {
                for (DeclareStatement statement : method.allDeclareStatements()) {
                    for (ExplicitVariable explVariable : statement.getVariables()) {
                        URI uri2 = EcoreUtil.getURI((EObject)explVariable);
                        if (uri2 == null || !uri2.hasFragment()) continue;
                        this.order.put(uri2, this.implicitVariableCounter.incrementAndGet());
                    }
                }
                for (ImplicitVariable implVariable : method.getImplicitVariables()) {
                    uri = EcoreUtil.getURI((EObject)implVariable);
                    if (uri == null || !uri.hasFragment()) continue;
                    this.order.put(uri, this.implicitVariableCounter.incrementAndGet());
                }
            }
        }
    }
}

