/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureEntry;
import com._1c.g5.v8.dt.bsl.model.SourceObjectLinkProvider;
import com._1c.g5.v8.dt.bsl.model.util.BslUtil;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.NamedElement;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedStringFeatureProvider;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.FeatureAccessComputedNameProvider;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.e1c.langtool.v8.dt.bsl.validation.AbstractTranslationAmbiguityValidator;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public abstract class AbstractDynamicFeatureAccessTranslationAmbiguityValidator
extends AbstractTranslationAmbiguityValidator {
    protected static final String EXCLUDE_NAME_PATTERN_PARAMETERN_NAME = "excludeFeatureNamePattern";
    protected static final String TYPES_SKIP_PROPERTIES_PARAMETERN_NAME = "typesToSkipProperties";
    protected static final Set<String> DEFAULT_TYPES_SKIP_PROPERTIES = Set.of("QueryResultSelection", "XDTODataObject", "SpreadsheetDocumentTemplateParameters", "Structure");
    private static final Map<String, AmbiguityCheckOptions> SKIP_AMBIGUITY_CHECK_TYPES = Map.of("QueryResultSelection", AmbiguityCheckOptions.SKIP_ALL);
    private final IComputedStringFeatureProvider userPropertyComputedDynamicFeatureAccess = (IComputedStringFeatureProvider)BslPlugin.getDefault().getInjector().getInstance(FeatureAccessComputedNameProvider.class);
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    @Inject
    private TypesComputer typesComputer;

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        DynamicFeatureAccess featureAccess = (DynamicFeatureAccess)object;
        String excludeNamePattern = parameters.getString(EXCLUDE_NAME_PATTERN_PARAMETERN_NAME);
        if (featureAccess.getName() == null || StringUtils.isNotEmpty((String)excludeNamePattern) && Pattern.compile(excludeNamePattern, 256).matcher(featureAccess.getName()).matches()) {
            return;
        }
        this.checkTranslationAmbiguity((EObject)featureAccess, resultAcceptor, parameters, monitor);
    }

    @Override
    protected boolean internalHasMultipleTranslations(EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor, Map<String, Set<String>> translations, ITranslatingProject translatingProject, boolean isEnglishScript, Environmental environmental, Environments environments) {
        if (monitor.isCanceled()) {
            return false;
        }
        if (object instanceof DynamicFeatureAccess) {
            boolean isMethod;
            DynamicFeatureAccess featureAccess = (DynamicFeatureAccess)object;
            if (this.userPropertyComputedDynamicFeatureAccess.isSupported((EObject)featureAccess) && !this.userPropertyComputedDynamicFeatureAccess.isComputedString((EObject)featureAccess, BslFeatureSettings.Literals.FEATURE_ACCESS__NAME)) {
                return false;
            }
            AmbiguityCheckOptions checkOptions = this.getAmbiguityCheckOptions(featureAccess, parameters);
            if (checkOptions == AmbiguityCheckOptions.SKIP_ALL) {
                return false;
            }
            boolean bl = isMethod = BslUtil.getInvocation((FeatureAccess)featureAccess) != null;
            if (isMethod && checkOptions.isSkipMethods() || !isMethod && checkOptions.isSkipProperties()) {
                return false;
            }
            String featureAccessName = featureAccess.getName();
            List features = this.dynamicFeatureAccessComputer.resolveObject((FeatureAccess)featureAccess, environmental.environments(), true);
            boolean featuresisEmpty = BslUtils.isEmptySource(features);
            if (featuresisEmpty) {
                if (monitor.isCanceled()) {
                    return false;
                }
                Map<TranslateLanguage, String> contextTranslations = this.getContextTranslations(translatingProject, featureAccess, monitor);
                if (!contextTranslations.isEmpty() && contextTranslations.size() == translatingProject.getModelLanguages().size()) {
                    return false;
                }
                ContextDefCache contextDefCache = this.getContextDefCache((EObject)featureAccess, isEnglishScript);
                if (monitor.isCanceled()) {
                    return false;
                }
                Set<Object> foundTranslations = isMethod && !checkOptions.isSkipMethods() ? contextDefCache.getMethodTranslations(featureAccessName, environments) : (!checkOptions.isSkipProperties() ? contextDefCache.getPropertyTranslations(featureAccessName, environments) : Collections.emptySet());
                if (monitor.isCanceled()) {
                    return false;
                }
                Set<String> foundDictionaryTranslations = this.collectDictionaryTranslations(translatingProject, featureAccess, parameters, monitor);
                TreeSet<Object> allFoundTranslations = new TreeSet<Object>(String.CASE_INSENSITIVE_ORDER);
                allFoundTranslations.addAll(foundTranslations);
                allFoundTranslations.addAll(foundDictionaryTranslations);
                if (allFoundTranslations.size() > 1) {
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    SortedSet<String> contextSensitiveTranslations = contextDefCache.findContextSensitiveTranslations(featureAccess);
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    foundDictionaryTranslations.removeAll(foundTranslations);
                    if (contextSensitiveTranslations.isEmpty()) {
                        translations.computeIfAbsent(featureAccessName, unusedKey -> new TreeSet(String.CASE_INSENSITIVE_ORDER)).addAll(allFoundTranslations);
                    } else if (contextSensitiveTranslations.size() > 1) {
                        translations.computeIfAbsent(featureAccessName, unusedKey -> new TreeSet(String.CASE_INSENSITIVE_ORDER)).addAll(contextSensitiveTranslations);
                    } else if (!foundDictionaryTranslations.isEmpty()) {
                        translations.computeIfAbsent(featureAccessName, unusedKey -> new TreeSet(String.CASE_INSENSITIVE_ORDER)).addAll(allFoundTranslations);
                    }
                }
                return translations.containsKey(featureAccessName) && translations.get(featureAccessName).size() > 1;
            }
            if (monitor.isCanceled()) {
                return false;
            }
            if (features.size() > 1) {
                Function<DuallyNamedElement, String> getNameFunction = isEnglishScript ? DuallyNamedElement::getNameRu : NamedElement::getName;
                Set computedFeatureNames = features.stream().map(FeatureEntry::getFeature).filter(feature -> feature instanceof DuallyNamedElement && !(feature instanceof DerivedProperty) && !(feature instanceof SourceObjectLinkProvider)).map(DuallyNamedElement.class::cast).map(getNameFunction).distinct().collect(Collectors.toSet());
                if (computedFeatureNames.size() > 1) {
                    translations.computeIfAbsent(featureAccessName, unusedKey -> new TreeSet(String.CASE_INSENSITIVE_ORDER)).addAll(computedFeatureNames);
                }
                return translations.containsKey(featureAccessName) && translations.get(featureAccessName).size() > 1;
            }
        }
        return false;
    }

    protected Set<String> collectDictionaryTranslations(ITranslatingProject project, DynamicFeatureAccess featureAccess, ICheckParameters parameters, IProgressMonitor monitor) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (monitor.isCanceled()) {
            return result;
        }
        List modelLanguages = project.getModelLanguages();
        if (modelLanguages.isEmpty() || monitor.isCanceled()) {
            return result;
        }
        IProjectTranslationReader reader = this.getReader(project.getProject());
        ContextTranslationKey value = this.createContextTranslationKey(featureAccess);
        for (TranslateLanguage language : modelLanguages) {
            if (monitor.isCanceled()) {
                return result;
            }
            String translation = reader.getStoredTranslation((TranslationKey)value, language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.COMMON});
            if (!StringUtils.isNotEmpty((String)translation)) continue;
            result.add(translation);
        }
        return result;
    }

    private AmbiguityCheckOptions getAmbiguityCheckOptions(DynamicFeatureAccess dynamicFeatureAccess, ICheckParameters parameters) {
        if (dynamicFeatureAccess.getSource() instanceof FeatureAccess) {
            FeatureAccess source = (FeatureAccess)dynamicFeatureAccess.getSource();
            Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)source, Environmental.class);
            List types = this.typesComputer.computeTypes((EObject)source, environmental.environments());
            String excludeTypeString = parameters.getString(TYPES_SKIP_PROPERTIES_PARAMETERN_NAME);
            if (!types.isEmpty() && !StringUtils.isBlank((String)excludeTypeString)) {
                TreeSet<String> typeNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                typeNames.addAll(Set.of(excludeTypeString.replace(" ", "").split(",")));
                for (TypeItem type : types) {
                    String name2 = McoreUtil.getTypeNameRu((TypeItem)type);
                    if ((name2 == null || !typeNames.contains(name2)) && ((name2 = McoreUtil.getTypeName((TypeItem)type)) == null || !typeNames.contains(name2))) continue;
                    return AmbiguityCheckOptions.SKIP_PROPERTIES;
                }
            }
            return types.stream().map(McoreUtil::getTypeName).filter(Objects::nonNull).map(name -> SKIP_AMBIGUITY_CHECK_TYPES.getOrDefault(name, AmbiguityCheckOptions.SKIP_NOTHING)).findFirst().orElse(AmbiguityCheckOptions.SKIP_NOTHING);
        }
        return AmbiguityCheckOptions.SKIP_NOTHING;
    }

    private Map<TranslateLanguage, String> getContextTranslations(ITranslatingProject project, DynamicFeatureAccess featureAccess, IProgressMonitor monitor) {
        HashMap<TranslateLanguage, String> result = new HashMap<TranslateLanguage, String>();
        if (monitor.isCanceled()) {
            return result;
        }
        List modelLanguages = project.getModelLanguages();
        if (modelLanguages.isEmpty()) {
            return result;
        }
        IProjectTranslationReader reader = this.getReader(project.getProject());
        ContextTranslationKey value = this.createContextTranslationKey(featureAccess);
        for (TranslateLanguage language : modelLanguages) {
            if (monitor.isCanceled()) {
                return result;
            }
            String translation = reader.getStoredTranslation((TranslationKey)value, language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.CONTEXT});
            if (!StringUtils.isNotEmpty((String)translation)) continue;
            result.put(language, translation);
        }
        return result;
    }

    private ContextTranslationKey createContextTranslationKey(DynamicFeatureAccess featureAccess) {
        IFile file = this.resourceLookup.getPlatformResource((EObject)featureAccess);
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)featureAccess, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME);
        return new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME, featureAccess.getName());
    }

    private static enum AmbiguityCheckOptions {
        SKIP_NOTHING(false, false),
        SKIP_PROPERTIES(true, false),
        SKIP_METHODS(false, true),
        SKIP_ALL(true, true);

        private boolean skipProperties;
        private boolean skipMethods;

        private AmbiguityCheckOptions(boolean skipProperties, boolean skipMethods) {
            this.skipProperties = skipProperties;
            this.skipMethods = skipMethods;
        }

        public boolean isSkipProperties() {
            return this.skipProperties;
        }

        public boolean isSkipMethods() {
            return this.skipMethods;
        }
    }
}

