/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.g5.v8.dt.check.BslCheckIssue;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.Issue;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefBslCacheProvider;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;

public abstract class AbstractTranslationAmbiguityValidator
extends BasicCheck {
    @Inject
    protected IResourceLookup resourceLookup;
    @Inject
    protected IV8ProjectManager v8ProjectManager;
    @Inject
    protected ITranslatingProjectManager projectManager;
    @Inject
    protected ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private ContextDefBslCacheProvider contextDefCacheProvider;
    @Inject
    private BslPreferences bslPreferences;
    @Inject
    private ITranslationStorageManager storageManager;
    private CollectingParameters collectingParameters;

    protected abstract String getMessageTemplate();

    protected abstract boolean internalHasMultipleTranslations(EObject var1, BasicCheck.ResultAcceptor var2, ICheckParameters var3, IProgressMonitor var4, Map<String, Set<String>> var5, ITranslatingProject var6, boolean var7, Environmental var8, Environments var9);

    protected boolean needValidation(IProject project) {
        if (project == null) {
            return false;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(project);
        return translatingProject.isTranslating() && !translatingProject.getModelLanguages().isEmpty() && (this.isScriptVariantChanged(translatingProject) || this.isDefaultLanguageChanged(translatingProject));
    }

    protected void checkTranslationAmbiguity(EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IProject project = this.resourceLookup.getProject(object);
        if (project == null || !this.needValidation(project)) {
            return;
        }
        TreeMap<String, Set<String>> translations = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        if (this.hasMultipleTranslations(object, resultAcceptor, parameters, monitor, translations)) {
            String messageTemplate = this.getMessageTemplate();
            for (Map.Entry entry : translations.entrySet()) {
                if (monitor.isCanceled()) {
                    return;
                }
                String message = MessageFormat.format(messageTemplate, entry.getKey(), entry.getValue());
                BslCheckIssue issue = new BslCheckIssue(message, this.getMessageFeature(), -1, ((Set)entry.getValue()).toArray(new String[0]));
                resultAcceptor.addIssue((Issue)issue);
            }
        }
    }

    protected ICollectingParameters getParameters(IProject project) {
        if (this.collectingParameters == null) {
            this.collectingParameters = CollectingParameters.builder().collectModel().collectComputedStrings().enableCache().build();
        }
        return this.collectingParameters;
    }

    protected ContextDefCache getContextDefCache(EObject context, boolean isTranslatedToRussian) {
        return this.contextDefCacheProvider.getContextDefCache(context, isTranslatedToRussian);
    }

    protected Environments getActualEnvs(EObject object) {
        return this.bslPreferences.getLoadEnvs(object);
    }

    protected boolean isScriptVariantChanged(ITranslatingProject project) {
        IV8Project translatingV8Project;
        List translatedProjects = project.getTranslatedProjects();
        if (!translatedProjects.isEmpty() && (translatingV8Project = this.v8ProjectManager.getProject(project.getProject())) != null) {
            ScriptVariant translatingScriptVariant = translatingV8Project.getScriptVariant();
            for (ITranslatedProject translatedProject : translatedProjects) {
                ITranslatedV8Project translatedV8Project = null;
                if (translatedProject instanceof ITranslatedV8Project) {
                    translatedV8Project = (ITranslatedV8Project)translatedProject;
                }
                if (translatedV8Project == null || translatingScriptVariant == translatedV8Project.getScriptVariant()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isDefaultLanguageChanged(ITranslatingProject project) {
        IV8Project translatingV8Project;
        List translatedProjects = project.getTranslatedProjects();
        if (!translatedProjects.isEmpty() && (translatingV8Project = this.v8ProjectManager.getProject(project.getProject())) != null) {
            Language translatingDefaultLanguage = translatingV8Project.getDefaultLanguage();
            for (ITranslatedProject translatedProject : translatedProjects) {
                ITranslatedV8Project translatedV8Project = null;
                if (translatedProject instanceof ITranslatedV8Project) {
                    translatedV8Project = (ITranslatedV8Project)translatedProject;
                }
                if (translatedV8Project == null || translatingDefaultLanguage == translatedV8Project.getDefaultLanguage()) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract EStructuralFeature getMessageFeature();

    protected IProjectTranslationReader getReader(IProject project) {
        return this.storageManager.getTranslationReader(project);
    }

    private boolean hasMultipleTranslations(EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor, Map<String, Set<String>> translations) {
        IProject project = this.resourceLookup.getProject(object);
        if (project == null || monitor.isCanceled()) {
            return false;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(project);
        boolean isEnglishScript = this.isEnglishScriptVariantProject(project);
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)object, Environmental.class);
        Environments environments = this.getActualEnvs(object).intersect(environmental.environments());
        return this.internalHasMultipleTranslations(object, resultAcceptor, parameters, monitor, translations, translatingProject, isEnglishScript, environmental, environments);
    }

    private boolean isEnglishScriptVariantProject(IProject project) {
        IV8Project v8Project = this.v8ProjectManager.getProject(project);
        return v8Project != null && v8Project.getScriptVariant() == ScriptVariant.ENGLISH;
    }
}

