/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.common.Symbols;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslCommentUtils;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslMultiLineCommentDocumentationProvider;
import com._1c.g5.v8.dt.bsl.documentation.comment.LinkPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TypeSection;
import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.Function;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.lcore.util.CaseInsensitiveString;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com.e1c.g5.v8.dt.check.BslDirectLocationIssue;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.DirectLocation;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.Issue;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.INode;

public class FunctionReturnTypes
extends BasicCheck {
    public static final String CHECK_ID = "function-return-types";
    public static final String UNKNOWN_TYPE_NAME_RU = "?\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439?";
    public static final String UNKNOWN_TYPE_NAME = "?Unknown?";
    public static final String UNKNOWN_FIELD_NAME_RU = "\u041f\u043e\u043b\u04351?";
    public static final String UNKNOWN_FIELD_NAME = "Field1?";
    public static final String TYPES_NEED_PROPERTIES_PARAMETER_NAME = "typesNeedProperties";
    public static final String TYPES_NEED_CONTAINING_PARAMETER_NAME = "typesNeedContainingType";
    public static final Set<String> DEFAULT_TYPES_NEED_PROPERTIES = Set.of("Structure", "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430", "FixedStructure", "\u0424\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430", "ValueTable", "\u0422\u0430\u0431\u043b\u0438\u0446\u0430\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439", "ValueTableRow", "\u0421\u0442\u0440\u043e\u043a\u0430\u0422\u0430\u0431\u043b\u0438\u0446\u044b\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439", "ValueTree", "\u0414\u0435\u0440\u0435\u0432\u043e\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439", "ValueTreeRow", "\u0421\u0442\u0440\u043e\u043a\u0430\u0414\u0435\u0440\u0435\u0432\u0430\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439", "KeyAndValue", "\u041a\u043b\u044e\u0447\u0418\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
    public static final Set<String> DEFAULT_TYPES_NEED_CONTAINING = Set.of("Array", "\u041c\u0430\u0441\u0441\u0438\u0432", "FixedArray", "\u0424\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439\u041c\u0430\u0441\u0441\u0438\u0432", "Map", "\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435", "FixedMap", "\u0424\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435");
    @Inject
    protected IResourceLookup resourceLookup;
    @Inject
    private TypesComputer typesComputer;
    @Inject
    private BslMultiLineCommentDocumentationProvider commentProvider;
    @Inject
    private BslPreferences bslPreferences;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.FunctionReturnTypes_title).description(Messages.FunctionReturnTypes_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.CODE_STYLE).module().checkedObjectType(new EClass[]{BslPackage.Literals.FUNCTION}).parameter(TYPES_NEED_PROPERTIES_PARAMETER_NAME, String.class, String.join((CharSequence)", ", DEFAULT_TYPES_NEED_PROPERTIES), Messages.FunctionReturnTypes_Types_need_properties__comma_separated_list).parameter(TYPES_NEED_CONTAINING_PARAMETER_NAME, String.class, String.join((CharSequence)", ", DEFAULT_TYPES_NEED_CONTAINING), Messages.FunctionReturnTypes_Types_need_containing_type__comma_separated_list);
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        Function func = (Function)object;
        if (StringUtils.isNullOrEmpty((String)func.getName())) {
            return;
        }
        IProject project = this.resourceLookup.getProject((EObject)func);
        if (project == null) {
            return;
        }
        if (!func.getPragmas().isEmpty() && func.getPragmas().stream().anyMatch(p -> StringUtils.isNotEmpty((String)p.getSymbol()) && StringUtils.isNotEmpty((String)p.getValue()) && Symbols.ANNOTATION_SYMBOLS.contains(new CaseInsensitiveString(p.getSymbol())))) {
            return;
        }
        if (func.isExport()) {
            this.checkDocCommentReturnTypes(func, resultAcceptor, monitor, parameters);
        } else {
            this.checkReturnTypes(func, resultAcceptor, monitor);
        }
    }

    private void checkReturnTypes(Function func, BasicCheck.ResultAcceptor resultAcceptor, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        List types = this.typesComputer.computeTypes((EObject)func, func.environments());
        if (types.isEmpty() && !monitor.isCanceled()) {
            BslDocumentationComment comment = BslCommentUtils.parseTemplateComment((Method)func, (boolean)this.isOldCommentFormat((EObject)func), (BslMultiLineCommentDocumentationProvider)this.commentProvider);
            if (!this.functionDocCommentHasReturnTypes(comment)) {
                if (monitor.isCanceled()) {
                    return;
                }
                String message = MessageFormat.format(Messages.FunctionReturnTypes_Function___0___has_no_return_computed_types_or_types_in_documentation_comment, func.getName());
                resultAcceptor.addIssue(message, (EStructuralFeature)McorePackage.Literals.NAMED_ELEMENT__NAME);
            }
            this.checkTemplateTypeAndField(comment, func, resultAcceptor, monitor);
        }
    }

    private void checkDocCommentReturnTypes(Function func, BasicCheck.ResultAcceptor resultAcceptor, IProgressMonitor monitor, ICheckParameters parameters) {
        if (monitor.isCanceled()) {
            return;
        }
        BslDocumentationComment comment = BslCommentUtils.parseTemplateComment((Method)func, (boolean)this.isOldCommentFormat((EObject)func), (BslMultiLineCommentDocumentationProvider)this.commentProvider);
        if (this.functionDocCommentHasReturnTypes(comment)) {
            Set<String> needContaining;
            Set<String> needProperties;
            if (monitor.isCanceled() || comment.getReturnSection() == null) {
                return;
            }
            List types = comment.getReturnSection().getReturnTypes();
            String type = this.getTypeNeededProperties(types, needProperties = FunctionReturnTypes.getTypesNeedPropertied(parameters));
            if (type != null) {
                if (monitor.isCanceled()) {
                    return;
                }
                String message = MessageFormat.format(Messages.FunctionReturnTypes_Export_function___0___must_provide_properties_for_complex_type___1___in_documentation_comment, func.getName(), type);
                resultAcceptor.addIssue(message, (EStructuralFeature)McorePackage.Literals.NAMED_ELEMENT__NAME);
            }
            if ((type = this.getTypeNeededContainigTypes(types, needContaining = FunctionReturnTypes.getTypesNeedContaining(parameters))) != null) {
                if (monitor.isCanceled()) {
                    return;
                }
                String message = MessageFormat.format(Messages.FunctionReturnTypes_Export_function___0___must_provide_containig_type_for_collections___1___in_documentation_comment, func.getName(), type);
                resultAcceptor.addIssue(message, (EStructuralFeature)McorePackage.Literals.NAMED_ELEMENT__NAME);
            }
        } else {
            if (monitor.isCanceled()) {
                return;
            }
            String message = MessageFormat.format(Messages.FunctionReturnTypes_Export_function___0___must_have_return_types_in_documentation_comment, func.getName());
            resultAcceptor.addIssue(message, (EStructuralFeature)McorePackage.Literals.NAMED_ELEMENT__NAME);
        }
        this.checkTemplateTypeAndField(comment, func, resultAcceptor, monitor);
    }

    private boolean functionDocCommentHasReturnTypes(BslDocumentationComment comment) {
        BslDocumentationComment.ReturnSection section = comment.getReturnSection();
        if (section != null && section.getReturnTypes().isEmpty()) {
            return this.isTypeLink(section.getDescription());
        }
        if (section == null && comment.getParametersSection() == null && comment.getCallOptionsSection() == null && comment.getExampleSection() == null) {
            return this.isTypeLink(comment.getDescription());
        }
        if (section == null) {
            return false;
        }
        for (TypeSection typeSection : section.getReturnTypes()) {
            for (TypeSection.TypeDefinition typeDefinition : typeSection.getTypeDefinitions()) {
                String typeName = typeDefinition.getTypeName();
                if (StringUtils.isNotEmpty((String)typeName)) {
                    return true;
                }
                if (!(typeDefinition instanceof TypeSection.LinkContainsTypeDefinition)) continue;
                TypeSection.LinkContainsTypeDefinition linkContains = (TypeSection.LinkContainsTypeDefinition)typeDefinition;
                LinkPart link = linkContains.getLink();
                return !this.isHttpLink(link);
            }
        }
        return false;
    }

    private boolean isTypeLink(BslDocumentationComment.Description description) {
        if (description != null && description.getParts().size() == 1 && description.getParts().get(0) instanceof LinkPart) {
            LinkPart link = (LinkPart)description.getParts().get(0);
            return !this.isHttpLink(link);
        }
        return false;
    }

    private boolean isHttpLink(LinkPart link) {
        return link.getLinkText().stripLeading().startsWith("http");
    }

    private String getTypeNeededProperties(List<TypeSection> types, Set<String> needProperties) {
        if (needProperties.isEmpty()) {
            return null;
        }
        for (TypeSection typeSection : types) {
            String type = this.getTypeNeededPropertyByDefinitions(typeSection.getTypeDefinitions(), needProperties);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private String getTypeNeededPropertyByDefinitions(List<TypeSection.TypeDefinition> typeDefinitions, Set<String> needProperties) {
        for (TypeSection.TypeDefinition typeDefinition : typeDefinitions) {
            String typeName = typeDefinition.getTypeName();
            if (!StringUtils.isNotEmpty((String)typeName)) continue;
            if (needProperties.contains(typeName.toLowerCase()) && typeDefinition.getFieldDefinitionExtension().isEmpty()) {
                return typeName;
            }
            String type = this.getTypeNeededPropertyByDefinitions(typeDefinition.getContainTypes(), needProperties);
            if (type != null) {
                return type;
            }
            for (TypeSection.FieldDefinition field : typeDefinition.getFieldDefinitionExtension()) {
                type = this.getTypeNeededProperties(field.getTypeSections(), needProperties);
                if (type == null) continue;
                return type;
            }
        }
        return null;
    }

    private String getTypeNeededContainigTypes(List<TypeSection> types, Set<String> needContaining) {
        if (needContaining.isEmpty()) {
            return null;
        }
        for (TypeSection typeSection : types) {
            String type = this.getTypeNeededContainigTypeByDefinitions(typeSection.getTypeDefinitions(), needContaining);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private String getTypeNeededContainigTypeByDefinitions(List<TypeSection.TypeDefinition> typeDefinitions, Set<String> needContaining) {
        for (TypeSection.TypeDefinition typeDefinition : typeDefinitions) {
            String typeName = typeDefinition.getTypeName();
            if (!StringUtils.isNotEmpty((String)typeName)) continue;
            if (needContaining.contains(typeName.toLowerCase()) && typeDefinition.getContainTypes().isEmpty()) {
                return typeName;
            }
            String type = this.getTypeNeededContainigTypeByDefinitions(typeDefinition.getContainTypes(), needContaining);
            if (type != null) {
                return type;
            }
            for (TypeSection.FieldDefinition field : typeDefinition.getFieldDefinitionExtension()) {
                type = this.getTypeNeededContainigTypes(field.getTypeSections(), needContaining);
                if (type == null) continue;
                return type;
            }
        }
        return null;
    }

    private void checkTemplateTypeAndField(BslDocumentationComment comment, Function func, BasicCheck.ResultAcceptor resultAcceptor, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        List lines = this.commentProvider.getDocumentationNodes((EObject)func);
        if (lines.isEmpty()) {
            return;
        }
        if (!monitor.isCanceled() && comment.getParametersSection() != null && !comment.getParametersSection().getParameterDefinitions().isEmpty()) {
            this.checkTemplateTypeAndField(comment.getParametersSection().getParameterDefinitions(), lines, func, resultAcceptor, monitor);
        }
        if (!monitor.isCanceled() && comment.getReturnSection() != null && !comment.getReturnSection().getReturnTypes().isEmpty()) {
            this.checkTemplateTypeAndField2(comment.getReturnSection().getReturnTypes(), lines, func, resultAcceptor, monitor);
        }
    }

    private void checkTemplateTypeAndField2(List<TypeSection> typeSections, List<INode> lines, Function func, BasicCheck.ResultAcceptor resultAcceptor, IProgressMonitor monitor) {
        for (TypeSection typeSection : typeSections) {
            if (monitor.isCanceled()) {
                return;
            }
            this.checkTemplateTypeAndField3(typeSection.getTypeDefinitions(), lines, func, resultAcceptor, monitor);
        }
    }

    private void checkTemplateTypeAndField3(List<TypeSection.TypeDefinition> typeDefinitions, List<INode> lines, Function func, BasicCheck.ResultAcceptor resultAcceptor, IProgressMonitor monitor) {
        for (TypeSection.TypeDefinition typeDef : typeDefinitions) {
            if (monitor.isCanceled()) {
                return;
            }
            if (UNKNOWN_TYPE_NAME_RU.equalsIgnoreCase(typeDef.getTypeName()) || UNKNOWN_TYPE_NAME.equalsIgnoreCase(typeDef.getTypeName())) {
                String message = Messages.FunctionReturnTypes_Rename_template_type_name;
                int globalOffset = this.getGlobalOffset(lines, typeDef.getLineNumber());
                int offset = globalOffset + typeDef.getNameOffset();
                DirectLocation directLocation = new DirectLocation(Integer.valueOf(offset), Integer.valueOf(typeDef.getTypeName().length()), null, (EObject)func);
                BslDirectLocationIssue issue = new BslDirectLocationIssue(message, directLocation);
                resultAcceptor.addIssue((Issue)issue);
            }
            this.checkTemplateTypeAndField3(typeDef.getContainTypes(), lines, func, resultAcceptor, monitor);
            this.checkTemplateTypeAndField(typeDef.getFieldDefinitionExtension(), lines, func, resultAcceptor, monitor);
        }
    }

    private void checkTemplateTypeAndField(List<TypeSection.FieldDefinition> fieldDefinitions, List<INode> lines, Function func, BasicCheck.ResultAcceptor resultAcceptor, IProgressMonitor monitor) {
        for (TypeSection.FieldDefinition fieldDefinition : fieldDefinitions) {
            if (monitor.isCanceled()) {
                return;
            }
            if (UNKNOWN_FIELD_NAME_RU.equalsIgnoreCase(fieldDefinition.getName()) || UNKNOWN_FIELD_NAME.equalsIgnoreCase(fieldDefinition.getName())) {
                String message = Messages.FunctionReturnTypes_Rename_template_field_name;
                int globalOffset = this.getGlobalOffset(lines, fieldDefinition.getLineNumber());
                int offset = globalOffset + fieldDefinition.getNameOffset();
                DirectLocation directLocation = new DirectLocation(Integer.valueOf(offset), Integer.valueOf(fieldDefinition.getName().length()), null, (EObject)func);
                BslDirectLocationIssue issue = new BslDirectLocationIssue(message, directLocation);
                resultAcceptor.addIssue((Issue)issue);
            }
            this.checkTemplateTypeAndField2(fieldDefinition.getTypeSections(), lines, func, resultAcceptor, monitor);
        }
    }

    private int getGlobalOffset(List<INode> lines, int lineNumber) {
        if (lineNumber < lines.size()) {
            return lines.get(lineNumber).getOffset();
        }
        return 0;
    }

    private boolean isOldCommentFormat(EObject object) {
        IProject project = this.resourceLookup.getProject(object);
        return this.bslPreferences.getDocumentCommentProperties(project).oldCommentFormat();
    }

    private static Set<String> getTypesNeedPropertied(ICheckParameters parameters) {
        String param = parameters.getString(TYPES_NEED_PROPERTIES_PARAMETER_NAME);
        if (!StringUtils.isBlank((String)param)) {
            String[] types = param.trim().replace(" ", "").toLowerCase().split(",");
            return Set.of(types);
        }
        return Set.of();
    }

    private static Set<String> getTypesNeedContaining(ICheckParameters parameters) {
        String param = parameters.getString(TYPES_NEED_CONTAINING_PARAMETER_NAME);
        if (!StringUtils.isBlank((String)param)) {
            String[] types = param.trim().replace(" ", "").toLowerCase().split(",");
            return Set.of(types);
        }
        return Set.of();
    }
}

