/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.NstrTypeComputer;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com.e1c.g5.v8.dt.check.BslCheckIssue;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.Issue;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class NstrCamelCaseWordValidator
extends BasicCheck {
    public static final String CHECK_ID = "module-nstr-camelcase";
    public static final Pattern CAMELCASE_PATTERN = Pattern.compile("\\p{L}+[\\w\\.]*\\p{Lu}+[\\p{L}\\w\\.]*", 264);
    private static final String EXCLUDE_WORD_PATTERN_PARAMETERN_NAME = "excludeWordPattern";
    private static final String EXCLUDE_WRITE_EVENT_LOG = "excludeWriteEventLog";
    private static final String WRITE_EVENT_LOG_RU = "\u0417\u0430\u043f\u0438\u0441\u044c\u0416\u0443\u0440\u043d\u0430\u043b\u0430\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438";
    private static final String WRITE_EVENT_LOG = "WriteLogEvent";
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private IV8ProjectManager v8ProjectManager;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.NstrCamelCaseWordValidator_title).description(Messages.NstrCamelCaseWordValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MINOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.SPELLING).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL}).parameter(EXCLUDE_WORD_PATTERN_PARAMETERN_NAME, String.class, "", Messages.NstrCamelCaseWordValidator_Exclude_CamelCase_word_pattern).parameter(EXCLUDE_WRITE_EVENT_LOG, Boolean.class, Boolean.TRUE.toString(), Messages.NstrCamelCaseWordValidator_Exclude_WriteEventLog_event_name);
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        String excludeWordPattern;
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        if (!this.typeComputer.containsAnyType(literal, new String[]{"NStr"}) || this.typeComputer.containsAnyType(literal, new String[]{"Nstr-format"})) {
            return;
        }
        if (parameters.getBoolean(EXCLUDE_WRITE_EVENT_LOG) && this.isWriteEventLogEventName(literal)) {
            return;
        }
        IV8Project v8project = this.v8ProjectManager.getProject((EObject)literal);
        if (v8project == null || v8project.getDefaultLanguage() == null) {
            return;
        }
        Map<String, String> nls = BslUtils.getNlsLocalStrings(literal);
        String defaultLanguageCode = v8project.getDefaultLanguage().getLanguageCode();
        String nlsString = nls.get(defaultLanguageCode);
        if (nls.isEmpty() || StringUtils.isNullOrEmpty((String)nlsString)) {
            return;
        }
        Set params = this.typeComputer.containsAnyType(literal, new String[]{"Replace-params"}) ? Utils.getParamsMapFromNls((String)nlsString).keySet() : new HashSet();
        Matcher matcher = CAMELCASE_PATTERN.matcher(nlsString);
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        while (matcher.find()) {
            String word = matcher.group(0);
            if (word.startsWith(".")) {
                word = word.substring(1);
            }
            if (word.endsWith(".")) {
                word = word.substring(0, word.length() - 1);
            }
            if (word.equals(word.toUpperCase()) || params.contains(word)) continue;
            found.add(word);
        }
        if (!found.isEmpty() && !StringUtils.isBlank((String)(excludeWordPattern = parameters.getString(EXCLUDE_WORD_PATTERN_PARAMETERN_NAME)))) {
            Pattern pattern = Pattern.compile(excludeWordPattern);
            Iterator iterator = found.iterator();
            while (iterator.hasNext()) {
                String word = (String)iterator.next();
                if (!pattern.matcher(word).matches()) continue;
                iterator.remove();
            }
        }
        if (!found.isEmpty()) {
            String message = MessageFormat.format(Messages.NstrCamelCaseWordValidator_NStr_literal_has_CamelCase_words__S, String.join((CharSequence)", ", found));
            BslCheckIssue issue = new BslCheckIssue(message, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES, -1, found.toArray(new String[0]));
            resultAcceptor.addIssue((Issue)issue);
        }
    }

    private boolean isWriteEventLogEventName(StringLiteral literal) {
        EObject parent = literal.eContainer();
        if (!(parent instanceof Invocation) || !NstrTypeComputer.isNls((Invocation)((Invocation)parent))) {
            return false;
        }
        EObject parent2 = parent.eContainer();
        if (!(parent2 instanceof Invocation)) {
            return false;
        }
        String parentName = ((Invocation)parent2).getMethodAccess().getName();
        return (WRITE_EVENT_LOG_RU.equalsIgnoreCase(parentName) || WRITE_EVENT_LOG.equalsIgnoreCase(parentName)) && ((Invocation)parent2).getParams().indexOf((Object)parent) == 0;
    }
}

