/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.BslFeaturesCollector;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.AbstractTranslationValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class NstrLiteralValidator
extends AbstractTranslationValidator {
    public static final String CHECK_ID = "nstr-translation";
    private static final String CHECK_NSTR_PARAMETER_IN_TRANSLATION_PARAMETER_NAME = "checkNstrLiteralParamInTranslation";
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    private final Map<IProject, CollectingParameters> collectingParameters = new ConcurrentHashMap<IProject, CollectingParameters>();

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        super.configureCheck(builder);
        builder.title(Messages.NstrLiteralValidator_title).description(Messages.NstrLiteralValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).parameter(CHECK_NSTR_PARAMETER_IN_TRANSLATION_PARAMETER_NAME, Boolean.class, Boolean.TRUE.toString(), Messages.NstrLiteralValidator_Check_each_translation_contains_replace_parameter).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        if (!this.typeComputer.containsAnyType(literal, new String[]{"NStr"})) {
            return;
        }
        this.checkTranslation((EObject)literal, resultAcceptor, parameters, monitor);
    }

    protected void checkTranslation(EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        IProject project = this.resourceLookup.getProject(object);
        if (project == null) {
            return;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(project);
        if (!translatingProject.isTranslating()) {
            return;
        }
        List languages = translatingProject.getInterfaceLanguages();
        if (languages.isEmpty()) {
            return;
        }
        BiConsumer<Object, FeatureValue> addAction = this.getAddAction(project, object, languages, resultAcceptor, parameters);
        BslFeaturesCollector collector = BslFeaturesCollector.create(object, this.getParameters(project, parameters), addAction);
        collector.process(monitor);
    }

    protected String getTranslation(IProject project, FeatureValue featureValue, TranslateLanguage language, EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters) {
        String translation = super.getTranslation(project, featureValue, language, object, resultAcceptor, parameters);
        boolean checkNstrLiteralParamInTranslation = parameters.getBoolean(CHECK_NSTR_PARAMETER_IN_TRANSLATION_PARAMETER_NAME);
        if (StringUtils.isNotEmpty((String)translation) && checkNstrLiteralParamInTranslation && object instanceof StringLiteral && this.typeComputer.containsAnyType((StringLiteral)object, new String[]{"Replace-params"})) {
            Map sourceParams = Utils.getParamsMapFromNls((String)featureValue.getContextKey().getValue());
            Map translationParams = Utils.getParamsMapFromNls((String)translation);
            for (Map.Entry entry : translationParams.entrySet()) {
                sourceParams.remove(entry.getKey());
            }
            if (!sourceParams.isEmpty()) {
                this.addNoParamMessage(object, resultAcceptor, language, sourceParams.values());
            }
        }
        return translation;
    }

    protected ICollectingParameters getParameters(IProject project, ICheckParameters parameters) {
        return (ICollectingParameters)this.collectingParameters.computeIfAbsent(project, k -> {
            boolean checkComputedStringTranslation = parameters.getBoolean("checkComputedStringTranslation");
            CollectingParameters.Builder builder = CollectingParameters.builder().collectInterface().enableCache();
            if (checkComputedStringTranslation) {
                builder.collectComputedStrings();
            }
            return builder.build();
        });
    }

    private BiConsumer<Object, FeatureValue> getAddAction(IProject project, EObject object, List<TranslateLanguage> languages, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters) {
        return (o, featureValue) -> {
            if (!StringUtils.isNotEmpty((String)featureValue.getContextKey().getValue())) {
                return;
            }
            HashSet languagesWithoutTranslation = Sets.newHashSet();
            for (TranslateLanguage language : languages) {
                String translation;
                if (!TranslationUtils.isValidFeatureForLanguage((FeatureSettings)featureValue.getContextKey().getFeatureSettings(), (TranslateLanguage)language) || !StringUtils.isNullOrEmpty((String)(translation = this.getTranslation(project, (FeatureValue)featureValue, language, object, resultAcceptor, parameters)))) continue;
                languagesWithoutTranslation.add(language.getName());
            }
            if (!languagesWithoutTranslation.isEmpty()) {
                this.addNoTranslationMessage(object, resultAcceptor, featureValue.getContextKey().getValue(), featureValue.getContextKey().getFeatureKey(), featureValue.getContextKey().getFeatureSettings(), languagesWithoutTranslation);
            }
        };
    }

    private EStructuralFeature getMessageFeature() {
        return BslPackage.Literals.STRING_LITERAL__LINES;
    }

    private void addNoParamMessage(EObject object, BasicCheck.ResultAcceptor resultAcceptor, TranslateLanguage language, Collection<String> params) {
        String message = MessageFormat.format(Messages.NstrLiteralValidator_NStr_translation_into_language_doesnt_contains_parameters, language.getName(), String.join((CharSequence)", ", params));
        resultAcceptor.addIssue(message, (Object)object, this.getMessageFeature());
    }
}

