/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.v8.dt.bsl.validation.AbstractDynamicFeatureAccessTranslationAmbiguityValidator;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PrunedDynamicFeatureAccessTranslationAmbiguityValidator
extends AbstractDynamicFeatureAccessTranslationAmbiguityValidator {
    public static final String CHECK_ID = "pruned-dynamic-feature-access-translation-ambiguity";
    private static final String DICTIONARY_PARAMETER_NAME = "dictionary";

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.PrunedDynamicFeatureAccessTranslationAmbiguityValidator_Title).description(Messages.PrunedDynamicFeatureAccessTranslationAmbiguityValidator_Description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).module().checkedObjectType(new EClass[]{BslPackage.Literals.DYNAMIC_FEATURE_ACCESS}).parameter("excludeFeatureNamePattern", String.class, "", Messages.PrunedDynamicFeatureAccessTranslationAmbiguityValidator_Exclude_feature_name_pattern).parameter("typesToSkipProperties", String.class, String.join((CharSequence)", ", DEFAULT_TYPES_SKIP_PROPERTIES), Messages.PrunedDynamicFeatureAccessTranslationAmbiguityValidator_Types_to_skip_check_all_their_properties).parameter(DICTIONARY_PARAMETER_NAME, String.class, "", Messages.PrunedDynamicFeatureAccessTranslationAmbiguityValidator_Dictionary);
    }

    @Override
    protected boolean needValidation(IProject project) {
        return project != null;
    }

    @Override
    protected EStructuralFeature getMessageFeature() {
        return BslPackage.Literals.FEATURE_ACCESS__NAME;
    }

    @Override
    protected String getMessageTemplate() {
        return Messages.PrunedDynamicFeatureAccessTranslationAmbiguityValidator_Ambiguous_feature_translations__0__1;
    }

    @Override
    protected Set<String> collectDictionaryTranslations(ITranslatingProject project, DynamicFeatureAccess featureAccess, ICheckParameters parameters, IProgressMonitor monitor) {
        String[] keyTranslationPairs;
        String dictionary = parameters.getString(DICTIONARY_PARAMETER_NAME);
        if (StringUtils.isBlank((String)dictionary)) {
            return Collections.emptySet();
        }
        String featureAccessName = featureAccess.getName();
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = keyTranslationPairs = dictionary.replace(" ", "").split(",");
        int n = keyTranslationPairs.length;
        int n2 = 0;
        while (n2 < n) {
            String keyTranslation = stringArray[n2];
            String[] keyTranslationSplitted = keyTranslation.split("=");
            if (keyTranslationSplitted.length == 2) {
                String key = keyTranslationSplitted[0];
                String translation = keyTranslationSplitted[1];
                if (!StringUtils.isBlank((String)key) && !StringUtils.isBlank((String)translation) && key.equals(featureAccessName)) {
                    result.add(translation);
                }
            }
            ++n2;
        }
        return result;
    }
}

