/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com.e1c.g5.v8.dt.check.BslCheckIssue;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.Issue;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.KeysCollector;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.AbstractTranslationValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StringLiteralKeysTranslationValidator
extends AbstractTranslationValidator {
    public static final String CHECK_ID = "string-literal-keys-translation-duplicate";
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private KeysCollector keysCollector;
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    @Inject
    private BslPreferences bslPreferences;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        super.configureCheck(builder);
        builder.title(Messages.StringLiteralKeysTranslationValidator_title).description(Messages.StringLiteralKeysTranslationValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        if (!this.typeComputer.containsAnyType(literal, new String[]{"Keys"})) {
            return;
        }
        IProject project = this.resourceLookup.getProject((EObject)literal);
        if (project == null) {
            return;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(project);
        if (!translatingProject.isTranslating() || translatingProject.getModelLanguages().isEmpty()) {
            return;
        }
        this.validate(translatingProject, literal, resultAcceptor, parameters, monitor);
    }

    protected EStructuralFeature getMessageFeature(FeatureSettings featureSettings) {
        return BslPackage.Literals.STRING_LITERAL__LINES;
    }

    private void validate(ITranslatingProject translatingProject, StringLiteral object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        IProject project = translatingProject.getProject();
        List modelLanguages = translatingProject.getModelLanguages();
        HashMap langTranslation = Maps.newHashMap();
        BiConsumer<Object, FeatureValue> action = (o, featureValue) -> {
            if (StringUtils.isNotEmpty((String)featureValue.getContextKey().getValue()) && featureValue.getContextKey().getFeatureSettings().equals(BslFeatureSettings.Literals.STRING_LITERAL__KEY)) {
                for (TranslateLanguage language : modelLanguages) {
                    String translation = this.getTranslation(project, (FeatureValue)featureValue, language, (EObject)object, resultAcceptor, parameters);
                    Set translations = (Set)langTranslation.get(language);
                    if (translations == null) {
                        translations = Sets.newHashSet();
                        langTranslation.put(language, translations);
                    }
                    if (translations.contains(translation)) {
                        this.addKeysDuplicatedTranslation((EObject)object, featureValue.getContextKey().getValue(), translation, language, resultAcceptor);
                        continue;
                    }
                    if (translation.isEmpty()) continue;
                    translations.add(translation);
                }
            }
        };
        CollectingContext context = new CollectingContext((ICollectingParameters)CollectingParameters.builder().collectModel().build(), this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, FeaturesCollectorUtil.getDefaultLanguageCode((EObject)object, (IV8ProjectManager)this.v8ProjectManager), action);
        this.keysCollector.collect(object, context, monitor);
    }

    private void addKeysDuplicatedTranslation(EObject object, String key, String itemTranslation, TranslateLanguage language, BasicCheck.ResultAcceptor resultAcceptor) {
        String message = MessageFormat.format(Messages.KeysTranslationValidator_Key__K__has_duplicated_translation__V__onto__L, key, itemTranslation, language.getName());
        String[] mapKeyLang = new String[]{key + ":" + language.getName()};
        BslCheckIssue issue = new BslCheckIssue(message, this.getMessageFeature(null), -1, mapKeyLang);
        resultAcceptor.addIssue((Issue)issue);
    }
}

