/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.e1c.langtool.v8.dt.bsl.validation.AbstractTranslationAmbiguityValidator;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StringLiteralTranslationAmbiguityValidator
extends AbstractTranslationAmbiguityValidator {
    public static final String CHECK_ID = "string-literal-translation-ambiguity";
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private InternalizeDbViewTermsProvider internalizeDbViewTermsProvider;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.StringLiteralTranslationAmbiguityValidator_title).description(Messages.StringLiteralTranslationAmbiguityValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        if (!this.typeComputer.containsAnyType(literal, new String[]{"Key", "Keys"})) {
            return;
        }
        this.checkTranslationAmbiguity((EObject)literal, resultAcceptor, parameters, monitor);
    }

    @Override
    protected String getMessageTemplate() {
        return Messages.DynamicFeatureAccessAmbiguityValidator_Ambiguous_string_literal_translations;
    }

    @Override
    protected boolean internalHasMultipleTranslations(EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor, Map<String, Set<String>> translations, ITranslatingProject translatingProject, boolean isEnglishScript, Environmental environmental, Environments environments) {
        if (object instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)object;
            String[] keys = BslUtils.splitStringKeys(stringLiteral);
            ContextDefCache contextDefCache = this.getContextDefCache((EObject)stringLiteral, isEnglishScript);
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Set<String> propertyTranslations;
                String key = stringArray[n2];
                String translation = this.internalizeDbViewTermsProvider.getInternalizeEnumValue(key, isEnglishScript);
                if (StringUtils.isNullOrEmpty((String)translation) && (propertyTranslations = contextDefCache.getPropertyTranslations(key, environments)).size() > 1) {
                    translations.computeIfAbsent(key, unusedKey -> new TreeSet(String.CASE_INSENSITIVE_ORDER)).addAll(propertyTranslations);
                }
                ++n2;
            }
            return !translations.isEmpty();
        }
        return false;
    }

    @Override
    protected EStructuralFeature getMessageFeature() {
        return BslPackage.Literals.STRING_LITERAL__LINES;
    }
}

