/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.Property;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com.e1c.g5.v8.dt.check.BslCheckIssue;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.Issue;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.stringliteral.KeysCollector;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.AbstractTranslationValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class TableKeysTranslationValidator
extends AbstractTranslationValidator {
    public static final String CHECK_ID = "table-column-translation-duplicate";
    private final TypesComputer typesComputer;
    private final DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    private final KeysCollector keyCollector;
    private final IStringLiteralTypeComputer stringLiteralTypeComputer;
    private final ICollectingParameters collectingParameters;
    private final BslPreferences bslPreferences;
    private boolean VALIDATOR_DISABLED = true;

    @Inject
    public TableKeysTranslationValidator(IStringLiteralTypeComputer stringLiteralTypeComputer, KeysCollector keyCollector, BslPreferences bslPreferences) {
        IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
        this.typesComputer = (TypesComputer)rsp.get(TypesComputer.class);
        this.dynamicFeatureAccessComputer = (DynamicFeatureAccessComputer)rsp.get(DynamicFeatureAccessComputer.class);
        this.keyCollector = keyCollector;
        this.stringLiteralTypeComputer = stringLiteralTypeComputer;
        this.collectingParameters = CollectingParameters.builder().collectModel().build();
        this.bslPreferences = bslPreferences;
    }

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        super.configureCheck(builder);
        builder.title(Messages.TableKeysTranslationValidator_title).description(Messages.TableKeysTranslationValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (this.VALIDATOR_DISABLED) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        if (!this.stringLiteralTypeComputer.containsAnyType(literal, new String[]{"Key"})) {
            return;
        }
        EObject inv = literal.eContainer();
        if (!(inv instanceof Invocation) || !(((Invocation)inv).getMethodAccess() instanceof DynamicFeatureAccess)) {
            return;
        }
        IProject project = this.resourceLookup.getProject(inv);
        if (project == null) {
            return;
        }
        EList params = ((Invocation)inv).getParams();
        if (params.isEmpty()) {
            return;
        }
        DynamicFeatureAccess methodAccess = (DynamicFeatureAccess)((Invocation)inv).getMethodAccess();
        String nameMethod = Strings.nullToEmpty((String)methodAccess.getName().toLowerCase());
        if (!this.isInsert(nameMethod) && !this.isAdd(nameMethod)) {
            return;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(project);
        List modelLanguages = translatingProject.getModelLanguages();
        if (!translatingProject.isTranslating() || modelLanguages.isEmpty()) {
            return;
        }
        Environmental envs = (Environmental)EcoreUtil2.getContainerOfType((EObject)methodAccess.getSource(), Environmental.class);
        List types = this.typesComputer.computeTypes((EObject)methodAccess.getSource(), envs.environments());
        if (types.size() != 1) {
            return;
        }
        DynamicFeatureAccess columns = (DynamicFeatureAccess)methodAccess.getSource();
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)columns.getSource(), Environmental.class);
        List typesColumns = this.typesComputer.computeTypes((EObject)columns.getSource(), environmental.environments()).stream().filter(this::isTableOrTree).collect(Collectors.toList());
        if (typesColumns.isEmpty()) {
            return;
        }
        Collection properties = this.dynamicFeatureAccessComputer.getAllProperties((Collection)types, envs.eResource()).stream().flatMap(e -> ((Collection)e.getFirst()).stream()).collect(Collectors.toList());
        if (properties.isEmpty()) {
            return;
        }
        Map<String, Map<TranslateLanguage, String>> sourceLangTranslation = this.collectTranslation(literal, resultAcceptor, project, properties, methodAccess, modelLanguages);
        this.validate(literal, resultAcceptor, project, modelLanguages, sourceLangTranslation);
    }

    private Map<String, Map<TranslateLanguage, String>> collectTranslation(StringLiteral stringLiteral, BasicCheck.ResultAcceptor resultAcceptor, IProject project, Collection<Property> propertiesStructure, DynamicFeatureAccess methodAccess, List<TranslateLanguage> modelLanguages) {
        TreeMap<String, Map<TranslateLanguage, String>> sourceLangTranslation = new TreeMap<String, Map<TranslateLanguage, String>>(String.CASE_INSENSITIVE_ORDER);
        for (TranslateLanguage language : modelLanguages) {
            ArrayList<TranslateLanguage> collection = new ArrayList<TranslateLanguage>();
            collection.add(language);
            for (Property property : propertiesStructure) {
                IFile file;
                if (!(property instanceof DerivedProperty) || (file = this.resourceLookup.getPlatformResource((EObject)property)) == null) continue;
                FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)property, (FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME);
                ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, property.getName());
                String itemTranslation = this.getReader(project).getStoredTranslation((TranslationKey)key, language, new ITranslationStorageProvider.Storage.Type[0]);
                if (StringUtils.isNullOrEmpty((String)itemTranslation)) continue;
                Map langTranslation = sourceLangTranslation.computeIfAbsent(property.getName(), k -> Maps.newHashMap());
                langTranslation.put(language, itemTranslation);
            }
        }
        return sourceLangTranslation;
    }

    private void validate(StringLiteral stringLiteral, BasicCheck.ResultAcceptor resultAcceptor, IProject project, List<TranslateLanguage> modelLanguages, Map<String, Map<TranslateLanguage, String>> sourceLangTranslation) {
        BiConsumer<Object, FeatureValue> action = (o, featureValue) -> {
            if (StringUtils.isNotEmpty((String)featureValue.getContextKey().getValue())) {
                for (TranslateLanguage language : modelLanguages) {
                    this.emitMessageForKeysDuplicated(stringLiteral, resultAcceptor, project, sourceLangTranslation, (FeatureValue)featureValue, language);
                }
            }
        };
        CollectingContext context = new CollectingContext(this.collectingParameters, this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, FeaturesCollectorUtil.getDefaultLanguageCode((EObject)stringLiteral, (IV8ProjectManager)this.v8ProjectManager), action);
        this.keyCollector.collect(stringLiteral, context, (IProgressMonitor)new NullProgressMonitor());
    }

    private void emitMessageForKeysDuplicated(StringLiteral stringLiteral, BasicCheck.ResultAcceptor resultAcceptor, IProject project, Map<String, Map<TranslateLanguage, String>> sourceLangTranslation, FeatureValue featureValue, TranslateLanguage language) {
        String translation = this.getReader(project).getStoredTranslation((TranslationKey)featureValue.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
        for (Map.Entry<String, Map<TranslateLanguage, String>> entry : sourceLangTranslation.entrySet()) {
            String translations = entry.getValue().get(language);
            if (translations == null || entry.getKey().equals(featureValue.getContextKey().getValue()) || !translations.contains(translation)) continue;
            this.emitMessageForKeysDuplicatedTranslation((EObject)stringLiteral, entry.getKey(), featureValue.getContextKey().getValue(), translation, language, resultAcceptor);
        }
    }

    protected EStructuralFeature getMessageFeature(FeatureSettings featureSettings) {
        return BslPackage.Literals.STRING_LITERAL__LINES;
    }

    private void emitMessageForKeysDuplicatedTranslation(EObject object, String key, String currentKey, String itemTranslation, TranslateLanguage language, BasicCheck.ResultAcceptor resultAcceptor) {
        String message = MessageFormat.format(Messages.KeyTranslationValidator_Key__K__has_duplicated_translation__V__onto__L, key, itemTranslation, language.getName());
        String[] mapKeyLang = new String[]{currentKey + ":" + language.getName()};
        BslCheckIssue issue = new BslCheckIssue(message, this.getMessageFeature(null), -1, mapKeyLang);
        resultAcceptor.addIssue((Issue)issue);
    }

    private boolean isTableOrTree(TypeItem type) {
        return "ValueTable".equalsIgnoreCase(McoreUtil.getTypeName((TypeItem)type)) || "ValueTree".equalsIgnoreCase(McoreUtil.getTypeName((TypeItem)type));
    }

    private boolean isInsert(String name) {
        return "insert".equalsIgnoreCase(name) || "\u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c".equalsIgnoreCase(name);
    }

    private boolean isAdd(String name) {
        return "add".equalsIgnoreCase(name) || "\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c".equalsIgnoreCase(name);
    }
}

