/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl;

import com._1c.g5.v8.dt.bm.xtext.BmAwareResourceSetProvider;
import com._1c.g5.v8.dt.bsl.resource.BslResource;
import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureCollectorFactory;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class BslFileFeatureCollectorFactory
implements FeatureCollectorFactory {
    @Inject
    private BmAwareResourceSetProvider resourceSetProvider;
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private IDtProjectManager dtProjectManager;
    @Inject
    private IWorkspaceOrchestrator workspaceOrchestrator;

    public boolean isSupport(Object object) {
        if (!(object instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)object;
        return file.getFileExtension() == null || "bsl".equalsIgnoreCase(file.getFileExtension());
    }

    public Set<FeatureValueCollector> createCollectors(Object object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isLegal((boolean)(object instanceof IFile), (String)"Object must be IFile");
        IFile file = (IFile)object;
        IProject project = file.getProject();
        IDtProject dtProject = this.dtProjectManager.getDtProject(project);
        if (dtProject == null) {
            return Collections.emptySet();
        }
        Object handle = this.workspaceOrchestrator.beginBackgroundOperation("create-BSL-file-collector", Arrays.asList(dtProject), ProjectPipelineJob.BUILD);
        this.workspaceOrchestrator.endOperation(handle);
        URI moduleUri = URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true).appendFragment("/0");
        HashSet<FeatureValueCollector> collectors = new HashSet<FeatureValueCollector>();
        BslResource.setSingleThreadMode();
        try {
            try {
                ResourceSet resourceSet = this.resourceSetProvider.get(file.getProject());
                EObject module = resourceSet.getEObject(moduleUri, true);
                if (module != null && !module.eIsProxy() && this.collectingService.hasCollector((Object)module)) {
                    TranslationSource source = TranslationUtils.getTranslationSource((Object)module);
                    collectors.addAll(this.collectingService.createCollectors(source, parameters, addAction));
                }
            }
            catch (Throwable e) {
                BslPlugin.logError(e);
                BslResource.resetSingleThreadMode();
            }
        }
        finally {
            BslResource.resetSingleThreadMode();
        }
        return collectors;
    }
}

