/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.languageprocessor;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.cleaner.BslNStrCleanupVisitor;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.languageprocessor.IObjectLanguageProcessor;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessorParameters;
import com.e1c.langtool.v8.dt.sync.EmfObjectProvider;
import com.e1c.langtool.v8.dt.xtext.ParseTreeVisitor;
import com.e1c.langtool.v8.dt.xtext.XtextUtils;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.StringInputStream;

public class BslLanguageProcessor
implements IObjectLanguageProcessor {
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;
    @Inject
    private EmfObjectProvider emfObjectProvider;
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private BslPreferences bslPreferences;

    public boolean isSupported(EPackage ePackage) {
        return BslPackage.eINSTANCE.equals(ePackage);
    }

    /*
     * WARNING - void declaration
     */
    public void process(URI objectURI, LanguageProcessorParameters parameters) {
        EObject object;
        EObject eObject;
        IFile currentFile = this.resourceLookup.getPlatformResource(objectURI);
        if (currentFile != null && (eObject = (object = this.emfObjectProvider.getObjectByFile(currentFile))) instanceof Module) {
            void module;
            Module module2 = (Module)eObject;
            Module cfr_ignored_0 = (Module)eObject;
            ICompositeNode rootNode = NodeModelUtils.getNode((EObject)module);
            Document cleanedDocument = new Document(rootNode.getText());
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            HashMap<TranslateLanguage, Map<ContextTranslationKey, String>> translations = new HashMap<TranslateLanguage, Map<ContextTranslationKey, String>>();
            BslNStrCleanupVisitor bslCleanupVisitor = new BslNStrCleanupVisitor(multiTextEdit, currentFile, parameters.getDefaultLanguageCode(), parameters.getTranslateLanguages(), parameters.isKeepLanguages(), translations, this.translationKeyProvider, this.typeComputer, this.bslPreferences);
            XtextUtils.walkParseTree((INode)rootNode, (ParseTreeVisitor)bslCleanupVisitor);
            try {
                multiTextEdit.apply((IDocument)cleanedDocument);
            }
            catch (BadLocationException | MalformedTreeException e) {
                BslPlugin.logError(e);
            }
            this.setFileContent(currentFile, (IDocument)cleanedDocument);
        }
    }

    private void setFileContent(IFile currentFile, IDocument cleanedDocument) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringInputStream input = new StringInputStream(cleanedDocument.get(), currentFile.getCharset());){
                if (currentFile.exists()) {
                    currentFile.setContents((InputStream)input, true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            BslPlugin.logError(e);
        }
    }
}

