/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.external.translator;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.external.ITranslatedExternalObjectProject;
import com.e1c.langtool.v8.dt.external.ITranslatingExternalObjectProject;
import com.e1c.langtool.v8.dt.internal.external.ExtPlugin;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.translator.ProjectTranslationProvider;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ExternalProjectTranslationProvider
extends ProjectTranslationProvider {
    private IProjectTranslationReader baseProjectTranslationReader;
    private IProject baseSourceProject;
    private Map<TranslateLanguage, TranslateLanguage> baseLanguages;
    private final boolean hasBaseProject = this.geExternalObjectProject().getTranslatedConfigurationProject() != null;

    public static ExternalProjectTranslationProvider create(ITranslatedV8Project translatedProject) {
        Assert.isLegal((translatedProject != null ? 1 : 0) != 0, (String)"translatedProject should not be null");
        ExternalProjectTranslationProvider provider = new ExternalProjectTranslationProvider(translatedProject);
        ExtPlugin.getDefault().getInjector().injectMembers((Object)provider);
        return provider;
    }

    protected ExternalProjectTranslationProvider(ITranslatedV8Project translatedProject) {
        super(translatedProject);
    }

    protected String getStoredTranslationInternal(ContextTranslationKey key, TranslateLanguage language, ITranslationStorageProvider.Storage.Type ... storageTypes) {
        TranslateLanguage baseLanguage;
        if (this.hasBaseProject && key != null && key.getSourceProject().equals((Object)this.getBaseSourceProject())) {
            if (this.ignoreService.ignoreTranslation(this.getBaseSourceProject(), key, (IProgressMonitor)new NullProgressMonitor())) {
                return key.getValue();
            }
            TranslateLanguage baseLanguage2 = this.getBaseLanguage(language);
            if (baseLanguage2 != null) {
                return this.getBaseReader().getStoredTranslation((TranslationKey)key, baseLanguage2, storageTypes);
            }
        }
        if (this.hasBaseProject && this.ignoreService.ignoreTranslation(this.getSourceProject(), key, (IProgressMonitor)new NullProgressMonitor())) {
            return key.getValue();
        }
        String translation = super.getStoredTranslationInternal(key, language, storageTypes);
        if (this.hasBaseProject && StringUtils.isNullOrEmpty((String)translation) && (baseLanguage = this.getBaseLanguage(language)) != null) {
            translation = this.getBaseReader().getStoredTranslation((TranslationKey)key, baseLanguage, storageTypes);
        }
        return translation;
    }

    protected ITranslatedExternalObjectProject geExternalObjectProject() {
        return (ITranslatedExternalObjectProject)this.getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProjectTranslationReader getBaseReader() {
        if (this.baseProjectTranslationReader == null) {
            ExternalProjectTranslationProvider externalProjectTranslationProvider = this;
            synchronized (externalProjectTranslationProvider) {
                if (this.baseProjectTranslationReader != null) {
                    return this.baseProjectTranslationReader;
                }
                this.baseProjectTranslationReader = this.storageManager.getTranslationReader(this.getBaseSourceProject());
            }
        }
        return this.baseProjectTranslationReader;
    }

    protected IProject getBaseSourceProject() {
        if (this.baseSourceProject == null) {
            Assert.isNotNull((Object)this.getProject());
            ITranslatingProject source = this.getProject().getSourceProject();
            Assert.isNotNull((Object)source);
            Assert.isLegal((boolean)(source instanceof ITranslatingExternalObjectProject));
            this.baseSourceProject = ((ITranslatingExternalObjectProject)source).getTranslatingConfigurationProject().getProject();
        }
        return this.baseSourceProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TranslateLanguage getBaseLanguage(TranslateLanguage source) {
        if (this.baseLanguages == null) {
            ExternalProjectTranslationProvider externalProjectTranslationProvider = this;
            synchronized (externalProjectTranslationProvider) {
                if (this.baseLanguages != null) {
                    return this.baseLanguages.get(source);
                }
                List sourceLanguages = this.geExternalObjectProject().getSourceProject().getInterfaceLanguages();
                this.baseLanguages = this.geExternalObjectProject().getInterfaceLanguages().stream().collect(Collectors.toMap(l -> l, l -> sourceLanguages.stream().filter(s -> s.getLanguageCode().equals(l.getLanguageCode())).findAny().orElse(null), (existing, replacement) -> existing));
            }
        }
        return this.baseLanguages.get(source);
    }
}

