/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.external;

import com._1c.g5.v8.dt.core.platform.IExternalObjectProject;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.external.ITranslatedExternalObjectProject;
import com.e1c.langtool.v8.dt.external.ITranslatingExternalObjectProject;
import com.e1c.langtool.v8.dt.platform.AbstractTranslateV8Project;
import com.e1c.langtool.v8.dt.platform.ITranslatedConfigurationProject;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedExternalObjectProject;
import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;

public class TranslatedExternalObjectProject
extends AbstractTranslateV8Project
implements ITranslatedExternalObjectProject {
    private final V8TranslatedExternalObjectProject translatedProject;
    private final ITranslatingExternalObjectProject sourceProject;
    private volatile List<TranslateLanguage> interfaceLanguages;
    private volatile List<Language> languages;

    public TranslatedExternalObjectProject(IProject project, V8TranslatedExternalObjectProject translatedProjectModel, ITranslatingExternalObjectProject sourceProject) {
        super(project);
        this.translatedProject = translatedProjectModel;
        this.sourceProject = sourceProject;
    }

    public boolean isTranslated() {
        return true;
    }

    public ITranslatingProject getSourceProject() {
        return this.sourceProject;
    }

    public String getProjectName() {
        return this.translatedProject.getName();
    }

    @Override
    public ITranslatedConfigurationProject getTranslatedConfigurationProject() {
        String baseProjectName = this.translatedProject.getBaseProject();
        if (baseProjectName != null && this.sourceProject.getTranslatingConfigurationProject() != null) {
            return this.sourceProject.getTranslatingConfigurationProject().getTranslatedProjects().stream().filter(p -> p instanceof ITranslatedConfigurationProject && p.getProjectName().equalsIgnoreCase(baseProjectName)).map(ITranslatedConfigurationProject.class::cast).findFirst().orElse(null);
        }
        return null;
    }

    public List<Language> getLanguages() {
        if (this.languages == null) {
            ArrayList<String> interfaceLanguageNames = new ArrayList<String>((Collection<String>)this.translatedProject.getInterfaceLanguageNames());
            if (!interfaceLanguageNames.contains(this.getDefaultLanguage().getName())) {
                interfaceLanguageNames.add(this.getDefaultLanguage().getName());
            }
            HashSet<Language> languageList = new HashSet<Language>();
            if (!interfaceLanguageNames.isEmpty()) {
                for (Language l2 : this.sourceProject.getV8Project().getLanguages()) {
                    if (!interfaceLanguageNames.contains(l2.getName())) continue;
                    languageList.add(l2);
                    interfaceLanguageNames.remove(l2.getName());
                }
            }
            List<TranslateLanguage> rest = this.convertNamesToLanguages(interfaceLanguageNames, true);
            rest.forEach(l -> {
                if (l instanceof Language && interfaceLanguageNames.contains(l.getName())) {
                    languageList.add((Language)l);
                    interfaceLanguageNames.remove(l.getName());
                }
            });
            this.languages = ImmutableList.copyOf(languageList);
        }
        return this.languages;
    }

    @Override
    public Collection<MdObject> getExternalObjects() {
        if (this.getV8Project() instanceof IExternalObjectProject) {
            return ((IExternalObjectProject)this.getV8Project()).getExternalObjects();
        }
        return Collections.emptyList();
    }

    public TranslateLanguage getDefaultLanguage() {
        if (!this.isChangeDefaultLanguage()) {
            return this.getSourceProject().getDefaultLanguage();
        }
        String langName = this.translatedProject.getDefaultLanguageName();
        if (langName != null) {
            Optional defaultLang = this.convertNamesToLanguages((List<String>)ImmutableList.of((Object)langName), false).stream().findFirst();
            if (defaultLang.isPresent()) {
                return (TranslateLanguage)defaultLang.get();
            }
            throw new RuntimeException(MessageFormat.format("Default language \"{0}\" for translation project not found", langName));
        }
        return this.getSourceProject().getDefaultLanguage();
    }

    public List<TranslateLanguage> getInterfaceLanguages() {
        if (this.interfaceLanguages == null) {
            TreeSet languageNames = new TreeSet();
            languageNames.addAll(this.translatedProject.getInterfaceLanguageNames());
            ArrayList<String> interfaceLanguageNames = new ArrayList<String>();
            interfaceLanguageNames.addAll(languageNames);
            List<TranslateLanguage> languageList = this.convertNamesToLanguages(interfaceLanguageNames, true);
            if (this.isChangeDefaultLanguage()) {
                languageList.add(this.getDefaultLanguage());
            }
            this.interfaceLanguages = ImmutableList.copyOf(languageList);
        }
        return this.interfaceLanguages;
    }

    @Override
    public ScriptVariant getScriptVariant() {
        if (this.translatedProject.isSetScriptVariant()) {
            return this.translatedProject.getScriptVariant();
        }
        return this.sourceProject.getScriptVariant();
    }

    public boolean isChangeScriptVariant() {
        return this.translatedProject.isSetScriptVariant() && !this.translatedProject.getScriptVariant().equals((Object)this.sourceProject.getV8Project().getScriptVariant());
    }

    public boolean isChangeDefaultLanguage() {
        return this.translatedProject.getDefaultLanguageName() != null && !this.translatedProject.getDefaultLanguageName().equalsIgnoreCase(this.getSourceProject().getDefaultLanguage().getName());
    }

    private List<TranslateLanguage> convertNamesToLanguages(List<String> languageNames, boolean interfaceOnly) {
        ITranslatingProject project = this.getSourceProject();
        HashSet parentLangs = new HashSet(project.getInterfaceLanguages());
        if (!interfaceOnly) {
            parentLangs.addAll(project.getModelLanguages());
        }
        Function<String, Optional> findLanguageByName = langName -> parentLangs.stream().filter(lang -> lang.getName().equals(langName)).findFirst();
        return languageNames.stream().map(findLanguageByName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

