/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.i18n.internal;

import com._1c.g5.wiring.InjectorAwareServiceRegistrator;
import com._1c.g5.wiring.ServiceInitialization;
import com.e1c.langtool.v8.dt.bsl.i18n.cache.BslContentCacheManager;
import com.e1c.langtool.v8.dt.bsl.i18n.internal.ExternalDependenciesModule;
import com.e1c.langtool.v8.dt.bsl.i18n.internal.ServiceModule;
import com.e1c.langtool.v8.dt.bsl.i18n.internal.loader.BslResourceExtension;
import com.e1c.langtool.v8.dt.bsl.i18n.loader.IBslLoadingPreprocessor;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class BslI18NPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.v8.dt.bsl.i18n";
    private static BslI18NPlugin plugin;
    private static BundleContext context;
    private InjectorAwareServiceRegistrator registrator;
    private volatile Injector injector;

    public static BslI18NPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        BslI18NPlugin.log(BslI18NPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        plugin = this;
        this.registrator = new InjectorAwareServiceRegistrator(context, this::getInjector);
        ServiceInitialization.schedule(() -> {
            try {
                this.registrator.managedService(BslContentCacheManager.class).activateBeforeRegistration().registerInjected();
                this.registrator.service(IBslLoadingPreprocessor.class).registerInjected();
                this.registrator.service(BslResourceExtension.class).registerInjected();
            }
            catch (Exception e) {
                BslI18NPlugin.logError(e);
            }
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registrator.deactivateManagedServices((Plugin)plugin);
        this.registrator.unregisterServices();
        this.injector = null;
        plugin = null;
        super.stop(bundleContext);
        context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<BslI18NPlugin> clazz = BslI18NPlugin.class;
        synchronized (BslI18NPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ServiceModule(), new ExternalDependenciesModule(this)});
        }
        catch (Exception e) {
            BslI18NPlugin.log(BslI18NPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

