/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.i18n.internal.cache;

import com._1c.g5.v8.dt.core.lifecycle.ProjectContext;
import com._1c.g5.v8.dt.core.lifecycle.ProjectStartType;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.bsl.i18n.cache.BslContentCacheManager;
import com.e1c.langtool.v8.dt.bsl.i18n.cache.IBslCacheInvalidationListener;
import com.e1c.langtool.v8.dt.bsl.i18n.internal.BslI18NPlugin;
import com.e1c.langtool.v8.dt.bsl.i18n.internal.cache.ProjectContentCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.osgi.framework.Bundle;

@Singleton
@LifecycleService(name="BslContentCacheManager")
public class BslContentCacheManagerImpl
implements BslContentCacheManager {
    private static final String DB_FILE_NAME = "bsl-i18n-cache";
    private final IStorageSettingsManager storageSettingsManager;
    private final ITranslationStorageManager storageManager;
    private ListenerList<IBslCacheInvalidationListener> listeners = new ListenerList();
    private Map<IProject, ProjectContentCache> projectCahes = new ConcurrentHashMap<IProject, ProjectContentCache>();
    private Map<IProject, IStorageValueChangedListener> storageListeners = new ConcurrentHashMap<IProject, IStorageValueChangedListener>();
    private IResourceChangeListener resourceListener = event -> {
        if (event.getResource() instanceof IProject) {
            IProject project = (IProject)event.getResource();
            this.dispose(project);
        }
    };

    @Inject
    public BslContentCacheManagerImpl(IStorageSettingsManager storageSettingsManager, ITranslationStorageManager storageManager) {
        this.storageSettingsManager = storageSettingsManager;
        this.storageManager = storageManager;
    }

    @LifecycleParticipant(phase=LifecyclePhase.INITIALIZATION)
    public void init(ProjectContext projectContext) {
        IDtProject dtProject = projectContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project != null) {
            ProjectStartType startType = projectContext.getStartType();
            if (startType.equals((Object)ProjectStartType.CLEAN_IMPORT) || startType.equals((Object)ProjectStartType.NEW_PROJECT)) {
                this.dispose(project);
            }
            this.projectCahes.computeIfAbsent(project, this::createProjectCache);
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.DISPOSING)
    public void dispose(ProjectContext lifecycleContext) {
        IDtProject dtProject = lifecycleContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project != null) {
            this.dispose(project);
        }
    }

    @Override
    public String get(IFile file) {
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        ProjectContentCache cache = this.projectCahes.computeIfAbsent(project, this::createProjectCache);
        return cache.get(file);
    }

    @Override
    public void invalidate(IFile file) {
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        ProjectContentCache cache = this.projectCahes.computeIfAbsent(project, this::createProjectCache);
        if (cache.invalidate(file)) {
            this.fireInvalidatedNotification(file);
        }
    }

    @Override
    public void put(IFile file, String content) {
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        this.ensureSubscribedToProjectStorages(project);
        ProjectContentCache cache = this.projectCahes.computeIfAbsent(project, this::createProjectCache);
        cache.put(file, content);
    }

    @Override
    public void addListener(IBslCacheInvalidationListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IBslCacheInvalidationListener listener) {
        this.listeners.remove((Object)listener);
    }

    private ProjectContentCache createProjectCache(IProject project) {
        File file = this.getProjectCacheFile(project);
        ProjectContentCache cache = new ProjectContentCache(project, file);
        try {
            cache.init();
            return cache;
        }
        catch (Throwable e) {
            cache.dispose();
            if (file != null) {
                try {
                    Files.deleteIfExists(file.toPath());
                }
                catch (IOException e1) {
                    BslI18NPlugin.logError(e1);
                }
            }
            try {
                cache.init();
                return cache;
            }
            catch (Exception e2) {
                BslI18NPlugin.logError(e2);
                cache.dispose();
                return cache;
            }
        }
    }

    private File getProjectCacheFile(IProject project) {
        if (BslI18NPlugin.getDefault() == null) {
            return null;
        }
        IPath path = Platform.getStateLocation((Bundle)BslI18NPlugin.getDefault().getBundle());
        IPath folder = path.append(project.getName());
        folder.toFile().mkdirs();
        return folder.append(DB_FILE_NAME).toFile();
    }

    private void ensureSubscribedToProjectStorages(IProject project) {
        List availableStorages = this.storageSettingsManager.getReadStorageIds(project);
        for (StorageID storageId : availableStorages) {
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageId);
            if (storage == null || storage.isReadOnly()) continue;
            IStorageValueChangedListener listener = this.storageListeners.computeIfAbsent(project, p -> event -> {
                TranslationKey translationKey = event.getTranslationKey();
                if (translationKey instanceof ContextTranslationKey) {
                    IProject source = ((ContextTranslationKey)translationKey).getSourceProject();
                    this.invalidate(source.getFile(((ContextTranslationKey)translationKey).getResourceId()));
                }
            });
            storage.addValueChangedListener(listener);
        }
    }

    private void fireInvalidatedNotification(IFile file) {
        for (IBslCacheInvalidationListener listener : this.listeners) {
            try {
                SafeRunner.run(() -> listener.invalidated(file));
            }
            catch (Throwable e) {
                BslI18NPlugin.logError(e);
            }
        }
    }

    public void activate() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 6);
    }

    public void deactivate() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        HashSet<IProject> projects = new HashSet<IProject>(this.projectCahes.keySet());
        for (IProject project : projects) {
            this.dispose(project);
        }
    }

    private void dispose(IProject project) {
        File file;
        ProjectContentCache cache;
        IStorageValueChangedListener listener = this.storageListeners.remove(project);
        if (listener != null) {
            List availableStorages = this.storageSettingsManager.getReadStorageIds(project);
            for (StorageID storageId : availableStorages) {
                ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageId);
                if (storage == null) continue;
                storage.removeValueChangedListener(listener);
            }
        }
        if ((cache = this.projectCahes.remove(project)) != null) {
            cache.dispose();
        }
        if ((file = this.getProjectCacheFile(project)) == null) {
            return;
        }
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            BslI18NPlugin.logError(e);
        }
    }
}

