/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.i18n.internal.cache;

import com.e1c.langtool.v8.dt.bsl.i18n.internal.cache.Value;
import com.e1c.langtool.v8.dt.bsl.i18n.internal.cache.ValueSerializer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class ProjectContentCache {
    private static final int CACHE_SIZE = 16;
    private static final String CACHE_CONTENT_MAP_NAME = "content";
    private final IProject project;
    private volatile DB db;
    private volatile ConcurrentMap<String, Value> cache = this.createInMemoryLruCache();
    private volatile boolean isClosed;
    private volatile boolean initialized;
    private final File file;

    public ProjectContentCache(IProject project, File file) {
        this.project = project;
        this.file = file;
    }

    public synchronized void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.isClosed = false;
        this.initializeDb();
        this.initialized = true;
    }

    private void initializeDb() {
        this.db = DBMaker.newFileDB((File)this.file).deleteFilesAfterClose().closeOnJvmShutdown().transactionDisable().cacheLRUEnable().cacheSize(16).make();
        this.cache = this.db.createHashMap(CACHE_CONTENT_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer((Serializer)new ValueSerializer()).counterEnable().makeOrGet();
        this.cache.size();
    }

    public synchronized void dispose() {
        if (!this.isClosed && this.db != null && !this.db.isClosed()) {
            this.db.close();
        }
        this.initialized = false;
        this.isClosed = true;
        this.db = null;
        this.cache = this.createInMemoryLruCache();
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean contains(IFile file) {
        this.checkAccess(file);
        Value value = (Value)this.cache.get(this.getKey(file));
        return value != null && value.modificationStamp == file.getModificationStamp();
    }

    public String get(IFile file) {
        this.checkAccess(file);
        Value result = this.cache.computeIfPresent(this.getKey(file), (key, value) -> {
            if (value.modificationStamp == file.getModificationStamp()) {
                return value;
            }
            return null;
        });
        return result == null ? null : result.content;
    }

    public boolean invalidate(IFile file) {
        this.checkAccess(file);
        return this.cache.remove(this.getKey(file)) != null;
    }

    public void put(IFile file, String content) {
        this.checkAccess(file);
        this.cache.compute(this.getKey(file), (path, value) -> {
            if (value == null) {
                return new Value(file.getModificationStamp(), content);
            }
            value.modificationStamp = file.getModificationStamp();
            value.content = content;
            return value;
        });
    }

    private void checkAccess(IFile file) {
        if (!file.getProject().equals((Object)this.project)) {
            throw new IllegalAccessError("Cannot access with file from another project");
        }
    }

    private String getKey(IFile file) {
        return file.getFullPath().toPortableString();
    }

    private ConcurrentMap<String, Value> createInMemoryLruCache() {
        Cache cache1 = CacheBuilder.newBuilder().maximumSize(16L).expireAfterAccess(20L, TimeUnit.MINUTES).weakValues().build();
        return cache1.asMap();
    }
}

