/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.i18n.internal.loader;

import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.util.BslUtil;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com.e1c.langtool.emf.naming.IFeatureKeyComputer;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.i18n.cache.BslContentCacheManager;
import com.e1c.langtool.v8.dt.bsl.i18n.internal.BslI18NPlugin;
import com.e1c.langtool.v8.dt.bsl.i18n.internal.loader.BslNStrPreprocessingVisitor;
import com.e1c.langtool.v8.dt.bsl.i18n.internal.loader.ProjectBslKeyComputer;
import com.e1c.langtool.v8.dt.bsl.i18n.loader.IBslLoadingPreprocessor;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.documentprocessingsettings.IDocumentProcessingSettingsManager;
import com.e1c.langtool.v8.dt.xtext.ParseTreeVisitor;
import com.e1c.langtool.v8.dt.xtext.XtextUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.StringInputStream;

@LifecycleService(name="BslPreprocessingService")
@Singleton
public class BslPreprocessingService
implements IBslLoadingPreprocessor {
    private IParser BSL_PARSER;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    private IDocumentProcessingSettingsManager documentProcessingSettingsManager;
    @Inject
    private TranslationPreferences translationPreferences;
    @Inject
    private BslPreferences bslPreferences;
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private BslContentCacheManager bslContentCacheManager;
    private boolean initialized = false;

    @Override
    public boolean isFileCanBeProcessed(IFile file) {
        if ("bsl".equals(file.getFileExtension()) && this.documentProcessingSettingsManager.isDocumentLoadProcessingEnabled()) {
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(file.getProject());
            return translatingProject != null && translatingProject.isTranslating();
        }
        return false;
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
        this.BSL_PARSER = resourceServiceProvider != null ? (IParser)resourceServiceProvider.get(IParser.class) : null;
    }

    @Override
    public InputStream processFile(IFile file, boolean force, InputStream originalStream) {
        String fileCharsetName;
        try {
            fileCharsetName = file.getCharset();
            String cachedContent = this.bslContentCacheManager.get(file);
            if (cachedContent != null) {
                if (originalStream != null) {
                    originalStream.close();
                }
                return new StringInputStream(cachedContent, fileCharsetName);
            }
        }
        catch (Throwable e) {
            BslI18NPlugin.logError(e);
            return originalStream;
        }
        if (this.BSL_PARSER == null) {
            return originalStream;
        }
        IProject project = file.getProject();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        if (!translatingProject.isTranslating()) {
            return originalStream;
        }
        StorageID storageId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
        ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageId);
        ITranslationStorageProvider.ContextStorage currentStorage = storage instanceof ITranslationStorageProvider.ContextStorage ? (ITranslationStorageProvider.ContextStorage)storage : null;
        if (currentStorage == null) {
            return originalStream;
        }
        try {
            Throwable throwable = null;
            Object var11_15 = null;
            try (BufferedInputStream bufferedStream = new BufferedInputStream(originalStream);){
                boolean isBinaryBsl;
                try {
                    isBinaryBsl = BslUtil.isBinaryBslFile((BufferedInputStream)bufferedStream, (String)file.getName());
                }
                catch (IOException e) {
                    isBinaryBsl = true;
                }
                ByteArrayInputStream contentStream = new ByteArrayInputStream(BslPreprocessingService.readFully(bufferedStream));
                if (isBinaryBsl) {
                    return contentStream;
                }
                InputStreamReader reader = new InputStreamReader((InputStream)contentStream, fileCharsetName);
                IParseResult parseResult = this.BSL_PARSER.parse((Reader)reader);
                ICompositeNode rootNode = parseResult.getRootNode();
                Document document = new Document(rootNode.getText());
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                TranslationProperties properties = this.translationPreferences.getTranslationProperties(project);
                TranslatorProperties bslProperties = this.bslPreferences.getTranslatorProperties(project);
                ProjectBslKeyComputer keyComputer = (ProjectBslKeyComputer)((Object)BslI18NPlugin.getDefault().getInjector().getInstance(ProjectBslKeyComputer.class));
                keyComputer.setDefaultLanguageCode(translatingProject.getDefaultLanguage().getLanguageCode());
                keyComputer.setTranslationProperties(bslProperties);
                BslNStrPreprocessingVisitor localizedBslGenerator = new BslNStrPreprocessingVisitor(multiTextEdit, translatingProject.getDefaultLanguage().getLanguageCode(), translatingProject.getInterfaceLanguages(), currentStorage, (IFeatureKeyComputer)keyComputer, file, properties, this.typeComputer, this.bslPreferences);
                XtextUtils.walkParseTree((INode)rootNode, (ParseTreeVisitor)localizedBslGenerator);
                multiTextEdit.apply((IDocument)document);
                String result = document.get();
                this.bslContentCacheManager.put(file, result);
                return new StringInputStream(result, fileCharsetName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            BslI18NPlugin.logError(e);
            return originalStream;
        }
    }

    private static byte[] readFully(InputStream stream) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(stream.available());
        while ((count = stream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, count);
        }
        return outputStream.toByteArray();
    }
}

