/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.i18n.internal.loader;

import com._1c.g5.v8.dt.core.resource.extension.IBslResourceExtension;
import com._1c.g5.v8.dt.core.resource.extension.IBslResourceExtensionManager;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com.e1c.langtool.v8.dt.bsl.i18n.loader.IBslLoadingPreprocessor;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

@LifecycleService(name="BslResourceExtension")
@Singleton
public class BslResourceExtension
implements IBslResourceExtension {
    private final IBslResourceExtensionManager bslResourceExtensionManager;
    private final IBslLoadingPreprocessor bslLoadingPreprocessor;
    private boolean initialized = false;

    @Inject
    public BslResourceExtension(IBslResourceExtensionManager bslResourceExtensionManager, IBslLoadingPreprocessor bslLoadingPreprocessor) {
        this.bslResourceExtensionManager = bslResourceExtensionManager;
        this.bslLoadingPreprocessor = bslLoadingPreprocessor;
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.bslResourceExtensionManager.setBslResourceExtension((IBslResourceExtension)this);
    }

    public InputStream replaceStreamIfNecessary(IFile bslFile, InputStream originalStream) {
        InputStream resultStream = null;
        resultStream = this.bslLoadingPreprocessor.isFileCanBeProcessed(bslFile) ? this.bslLoadingPreprocessor.processFile(bslFile, false, originalStream) : originalStream;
        return resultStream;
    }

    public InputStream replaceStreamIfNecessary(Resource bslResource, InputStream originalStream, Map<?, ?> options) {
        if (bslResource == null) {
            return originalStream;
        }
        URI uri = bslResource.getURI();
        if (uri == null || !uri.isPlatform()) {
            return originalStream;
        }
        String platformString = uri.toPlatformString(true);
        if (platformString == null || platformString.length() == 0 || !Path.isValidPosixPath((String)platformString)) {
            return originalStream;
        }
        IFile bslFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
        return this.replaceStreamIfNecessary(bslFile, originalStream);
    }
}

