/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.stat.internal.ui;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.Statistics;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class FullyTranslatedViewerFilter
extends ViewerFilter {
    public static final String ID = "com.e1c.langtool.stat.ui.translationStatistic.filters.FullyTranslated";
    private final ITranslatingProjectManager translatingProjectManager;

    @Inject
    public FullyTranslatedViewerFilter(ITranslatingProjectManager translatingProjectManager) {
        this.translatingProjectManager = translatingProjectManager;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IProject project = this.getProject(element);
        if (project == null) {
            return false;
        }
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            return false;
        }
        List<Metric> metrics = this.getVisibleMetrics(viewer);
        if (metrics.isEmpty()) {
            return false;
        }
        Statistics statistics = (Statistics)Adapters.adapt((Object)element, Statistics.class);
        if (statistics == null) {
            return true;
        }
        boolean select = false;
        for (Metric metric : metrics) {
            int baseValue = statistics.getMetricValue(metric);
            if (baseValue <= 0) continue;
            select = true;
            break;
        }
        if (!select) {
            return select;
        }
        TranslateLanguage language = (TranslateLanguage)Adapters.adapt((Object)element, TranslateLanguage.class);
        if (language == null) {
            for (TranslateLanguage lang : translating.getInterfaceLanguages()) {
                if (!this.select(statistics, metrics, lang)) continue;
                return true;
            }
            return false;
        }
        return this.select(statistics, metrics, language);
    }

    private boolean select(Statistics statistics, List<Metric> metrics, TranslateLanguage language) {
        for (Metric metric : metrics) {
            int baseValue = statistics.getMetricValue(metric);
            if (baseValue <= 0 || !metric.isApplicable(language) || baseValue <= statistics.getMetricValue(metric, language).getTranslatedCount()) continue;
            return true;
        }
        return false;
    }

    private IProject getProject(Object element) {
        TranslationSource source;
        IResource resource;
        IProject project = (IProject)Adapters.adapt((Object)element, IProject.class);
        if (project == null && (resource = (IResource)Adapters.adapt((Object)element, IResource.class)) != null) {
            project = resource.getProject();
        }
        if (project == null && (source = TranslationUtils.getTranslationSource((Object)element)) != null) {
            project = source.getProject();
        }
        return project;
    }

    private List<Metric> getVisibleMetrics(Viewer viewer) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        if (viewer.getControl() instanceof Tree) {
            Tree tree = (Tree)viewer.getControl();
            int i = 0;
            while (i < tree.getColumnCount()) {
                TreeColumn column = tree.getColumn(i);
                Object data = column.getData("metric");
                if (data instanceof Metric) {
                    metrics.add((Metric)data);
                }
                ++i;
            }
        }
        return metrics;
    }
}

