/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.stat.internal.ui;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.stat.Statistics;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.PlatformObject;

public class NavigatorTranslateLanguageAdapter
extends PlatformObject
implements TranslateLanguage {
    private final Object parent;
    private final IResource resource;
    private final TranslateLanguage language;
    private Statistics statistics;

    public NavigatorTranslateLanguageAdapter(IResource resource, Object parent, TranslateLanguage language) {
        this.parent = parent;
        this.resource = resource;
        this.language = language;
    }

    public UUID getUuid() {
        return this.language.getUuid();
    }

    public String getName() {
        return this.language.getName();
    }

    public String getPresentation() {
        return this.language.getPresentation();
    }

    public String getLanguageCode() {
        return this.language.getLanguageCode();
    }

    public TranslationOption getOption() {
        return this.language.getOption();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IProject.class) {
            return adapter.cast(this.resource.getProject());
        }
        if (adapter == TranslateLanguage.class) {
            return adapter.cast(this.language);
        }
        if (adapter == TranslationSource.class) {
            return adapter.cast(TranslationUtils.getTranslationSource((Object)this.parent));
        }
        if (adapter == Statistics.class) {
            return adapter.cast(this.getStatistic());
        }
        return (T)super.getAdapter(adapter);
    }

    public Object getParent() {
        return this.parent;
    }

    public IResource getResource() {
        return this.resource;
    }

    public Statistics getStatistic() {
        if (this.statistics == null) {
            this.statistics = (Statistics)Adapters.adapt((Object)this.resource, Statistics.class);
        }
        return this.statistics;
    }
}

