/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.stat.internal.ui;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.internal.ui.NavigatorTranslateLanguageAdapter;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class TranslateLanguageContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    @Inject
    private ITranslatingProjectManager translatingProjectManager;

    public Object[] getElements(Object inputElement) {
        return EMPTY;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof NavigatorTranslateLanguageAdapter) {
            return EMPTY;
        }
        IProject project = null;
        IResource resource = null;
        TranslationSource source = TranslationUtils.getTranslationSource((Object)element);
        if (source != null) {
            project = source.getProject();
            resource = project.getFile(source.getProjectRelativePath());
        } else {
            resource = (IResource)Adapters.adapt((Object)element, IResource.class);
            if (resource == null) {
                resource = (IResource)Adapters.adapt((Object)element, IProject.class);
            }
            if (resource == null) {
                return EMPTY;
            }
            project = resource.getProject();
        }
        if (project != null) {
            IResource res = resource;
            List languages = this.translatingProjectManager.getProject(project).getInterfaceLanguages();
            if (languages.size() > 1) {
                return languages.stream().map(l -> new NavigatorTranslateLanguageAdapter(res, element, (TranslateLanguage)l)).toArray();
            }
        }
        return EMPTY;
    }

    public Object getParent(Object element) {
        if (element instanceof NavigatorTranslateLanguageAdapter) {
            return ((NavigatorTranslateLanguageAdapter)((Object)element)).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof NavigatorTranslateLanguageAdapter) {
            return false;
        }
        IResource resource = (IResource)Adapters.adapt((Object)element, IResource.class);
        if (resource == null) {
            resource = (IResource)Adapters.adapt((Object)element, IProject.class);
        }
        return resource != null && this.translatingProjectManager.getProject(resource.getProject()).getInterfaceLanguages().size() > 1;
    }
}

