/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.stat.internal.ui;

import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.StatisticsService;
import com.e1c.langtool.stat.StatisticsUtil;
import com.e1c.langtool.stat.internal.ui.Messages;
import com.e1c.langtool.stat.internal.ui.UiPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.preferences.ViewSettingsDialog;

public class TranslationStatisticViewSettingsDialog
extends ViewSettingsDialog {
    private final StatisticsService statisticService;
    private final IObservableList<Metric> input = new WritableList();
    private CheckboxTableViewer metricViewer;
    private DataBindingContext dbc;

    public TranslationStatisticViewSettingsDialog(Shell parentShell, StatisticsService statisticService) {
        super(parentShell);
        this.statisticService = statisticService;
    }

    public boolean close() {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        this.input.dispose();
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TranslationStatisticViewSettingsDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.dbc = new DataBindingContext();
        Composite top = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(top);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)top);
        this.metricViewer = CheckboxTableViewer.newCheckList((Composite)top, (int)2048);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.metricViewer.getTable());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.metricViewer.getTable());
        ViewerSupport.bind((StructuredViewer)this.metricViewer, this.input, (IValueProperty)PojoProperties.value(Metric.class, (String)"title", String.class));
        IViewerObservableValue selection = ViewerProperties.singlePostSelection(Metric.class).observe((Viewer)this.metricViewer);
        Composite buttons = new Composite(top, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        GridDataFactory.fillDefaults().applyTo((Control)buttons);
        this.createUpDownButtons(buttons, (IObservableValue<Metric>)selection);
        Text detailText = new Text(top, 2634);
        GridDataFactory.fillDefaults().grab(true, true).minSize(10, 50).applyTo((Control)detailText);
        UpdateValueStrategy convert = UpdateValueStrategy.create((IConverter)IConverter.create(metric -> {
            if (metric != null) {
                return metric.getDescription();
            }
            return "";
        }));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)detailText), (IObservableValue)selection, UpdateValueStrategy.never(), convert);
        this.dbc.bindValue((IObservableValue)WidgetProperties.tooltipText().observe((Widget)detailText), (IObservableValue)selection, UpdateValueStrategy.never(), convert);
        this.loadMetrics();
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore prefs = UiPlugin.getDefault().getPreferenceStore();
        prefs.putValue("metricOrder", StatisticsUtil.DEFAUTL_METRIC_ORDER);
        this.loadMetrics();
        super.performDefaults();
    }

    protected void okPressed() {
        this.saveSelectedIds();
        super.okPressed();
    }

    private void loadMetrics() {
        this.input.clear();
        List<String> selectedIds = this.loadSelectedIds();
        Map<String, Metric> allMetrics = this.statisticService.getMetrics().stream().collect(Collectors.toMap(Metric::getID, m -> m));
        List selected = selectedIds.stream().map(allMetrics::get).filter(Objects::nonNull).collect(Collectors.toList());
        this.input.addAll(selected);
        this.metricViewer.setCheckedElements(selected.toArray());
        ArrayList<Metric> rest = new ArrayList<Metric>(allMetrics.values());
        rest.removeAll(selected);
        this.input.addAll(rest);
    }

    private List<String> loadSelectedIds() {
        IPreferenceStore prefs = UiPlugin.getDefault().getPreferenceStore();
        String settings = prefs.getString("metricOrder");
        String[] order = settings.split(",");
        return List.of(order);
    }

    private void saveSelectedIds() {
        IPreferenceStore prefs = UiPlugin.getDefault().getPreferenceStore();
        List selected = Arrays.stream(this.metricViewer.getCheckedElements()).filter(Metric.class::isInstance).map(Metric.class::cast).map(Metric::getID).collect(Collectors.toList());
        String order = String.join((CharSequence)",", selected);
        prefs.putValue("metricOrder", order);
    }

    private void createUpDownButtons(Composite parent, IObservableValue<Metric> selection) {
        Button upButton = new Button(parent, 132);
        upButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Metric metric;
            int index;
            if (selection.getValue() != null && (index = this.input.indexOf((Object)(metric = (Metric)selection.getValue()))) > 0) {
                boolean checked = this.metricViewer.getChecked((Object)metric);
                Metric prev = (Metric)this.input.get(index - 1);
                boolean prevChecked = this.metricViewer.getChecked((Object)prev);
                this.input.set(index - 1, (Object)metric);
                this.input.set(index, (Object)prev);
                this.metricViewer.setChecked((Object)metric, checked);
                this.metricViewer.setChecked((Object)prev, prevChecked);
                this.metricViewer.setSelection((ISelection)new StructuredSelection((Object)metric), true);
            }
        }));
        Button downButton = new Button(parent, 1028);
        downButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Metric metric;
            int index;
            if (selection.getValue() != null && (index = this.input.indexOf((Object)(metric = (Metric)selection.getValue()))) < this.input.size() - 1) {
                boolean checked = this.metricViewer.getChecked((Object)metric);
                Metric prev = (Metric)this.input.get(index + 1);
                boolean prevChecked = this.metricViewer.getChecked((Object)prev);
                this.input.set(index + 1, (Object)metric);
                this.input.set(index, (Object)prev);
                this.metricViewer.setChecked((Object)metric, checked);
                this.metricViewer.setChecked((Object)prev, prevChecked);
                this.metricViewer.setSelection((ISelection)new StructuredSelection((Object)metric), true);
            }
        }));
        UpdateValueStrategy converter = UpdateValueStrategy.create((IConverter)IConverter.create(Objects::nonNull));
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)upButton), selection, UpdateValueStrategy.never(), converter);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)downButton), selection, UpdateValueStrategy.never(), converter);
    }
}

