/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.stat.internal.ui;

import com.e1c.langtool.stat.internal.ui.ExternalDependenciesModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.stat.ui";
    public static final String IMG_UNTRANSLATED_KEY = "untranslated-key.png";
    private static final String ICONS_PATH = "/icons";
    private static UiPlugin plugin;
    private volatile Injector injector;
    private BundleContext bundleContext;

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        UiPlugin.log(UiPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        this.injector = null;
        plugin = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(IMG_UNTRANSLATED_KEY, UiPlugin.createImageDescriptorFromKey(IMG_UNTRANSLATED_KEY));
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String id) {
        return plugin.getImageRegistry().get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<UiPlugin> clazz = UiPlugin.class;
        synchronized (UiPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    protected BundleContext getContext() {
        return this.bundleContext;
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ExternalDependenciesModule((Plugin)this)});
        }
        catch (Exception e) {
            UiPlugin.log(UiPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }

    private static ImageDescriptor createImageDescriptorFromKey(String key) {
        String path = ICONS_PATH + File.separator + key;
        return UiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

