/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.stat.internal.ui.prefs;

import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com.e1c.langtool.stat.StatisticsManager;
import com.e1c.langtool.stat.StatisticsPreferences;
import com.e1c.langtool.stat.StatisticsService;
import com.e1c.langtool.stat.internal.ui.UiPlugin;
import com.e1c.langtool.stat.internal.ui.prefs.Messages;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TranslationStatisticsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    @Inject
    private StatisticsService statisticsService;
    @Inject
    private IWorkspaceOrchestrator orchestrator;
    @Inject
    private IDtProjectManager dtProjectManager;
    private Button enableTranslationStatisticsUntranslatedKeys;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(UiPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Composite field = this.createFieldComposite(composite);
        this.enableTranslationStatisticsUntranslatedKeys = new Button(field, 32);
        this.enableTranslationStatisticsUntranslatedKeys.setSelection(StatisticsPreferences.isEnableStatisticsUntranslatedKeys());
        new Label(field, 0).setText(Messages.TranslationStatisticsPage_Enable_statistics_untranslated_keys);
        return composite;
    }

    public boolean performOk() {
        boolean needRecompute = StatisticsPreferences.isEnableStatisticsUntranslatedKeys() ^ this.enableTranslationStatisticsUntranslatedKeys.getSelection();
        if (needRecompute && this.askForRecomputeStatistics()) {
            for (IProject project : this.getProjects()) {
                IDtProject dtProject = this.dtProjectManager.getDtProject(project);
                if (dtProject == null) continue;
                RecomputeStatisticsJob task = new RecomputeStatisticsJob(project, dtProject);
                try {
                    ForkJoinPool.commonPool().execute(task);
                }
                catch (Throwable e) {
                    UiPlugin.logError(e);
                }
            }
        }
        StatisticsPreferences.setEnableStatisticsUntranslatedKeys((boolean)this.enableTranslationStatisticsUntranslatedKeys.getSelection());
        return super.performOk();
    }

    private Composite createFieldComposite(Composite parent) {
        return this.createFieldComposite(parent, 0);
    }

    private Composite createFieldComposite(Composite parent, int indent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = indent;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    private boolean askForRecomputeStatistics() {
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.TranslationStatisticsPage_Recompute_window_title, null, Messages.TranslationStatisticsPage_Ask_for_recompute, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
        return dialog.open() == 0;
    }

    private List<IProject> getProjects() {
        return Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(IProject::isOpen).collect(Collectors.toList());
    }

    private class RecomputeStatisticsJob
    implements Runnable {
        private final IProject project;
        private final IDtProject dtProject;

        private RecomputeStatisticsJob(IProject project, IDtProject dtProject) {
            this.project = project;
            this.dtProject = dtProject;
        }

        @Override
        public void run() {
            Object handle = TranslationStatisticsPage.this.orchestrator.beginBackgroundOperation(Messages.TranslationStatisticsPage_Recompute_statistics_operation_name, List.of(this.dtProject), ProjectPipelineJob.BUILD);
            try {
                try {
                    ResourcesPlugin.getWorkspace().run(runnableMonitor -> {
                        StatisticsManager manager = TranslationStatisticsPage.this.statisticsService.getManager(this.project);
                        manager.startRecomputeFullStatistic();
                    }, (ISchedulingRule)this.project, 1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    UiPlugin.logError(e);
                    TranslationStatisticsPage.this.orchestrator.endOperation(handle);
                }
            }
            finally {
                TranslationStatisticsPage.this.orchestrator.endOperation(handle);
            }
        }
    }
}

