/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.tlx.importer;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.bm.integration.IBmTask;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.v8.dt.projectsettings.DependentManifestUtils;
import com.e1c.langtool.v8.dt.tlx.importer.internal.TlxImporterPlugin;
import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;

public class TranslateLanguageChangeListener
implements IResourceChangeListener {
    private static final String FOLDER_LANGUAGES = "languages";
    private static final String FOLDER_SRC = "src";
    private final Map<File, IProject> manifests = new ConcurrentHashMap<File, IProject>();
    @Inject
    private IBmModelManager modelManager;

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta eventDelta = event.getDelta();
        if ((event.getType() == 4 || event.getType() == 2) && event.getResource() != null) {
            this.fillPathManifests(event.getResource());
        }
        if (event.getType() == 1 && eventDelta != null) {
            try {
                HashMap<IProject, List<String>> removedLanguagesMap = new HashMap<IProject, List<String>>();
                this.fillRemovedLanguagesMap(eventDelta, removedLanguagesMap);
                this.removeLanguages(removedLanguagesMap);
            }
            catch (CoreException e) {
                TlxImporterPlugin.logError(e);
            }
        }
    }

    private void fillPathManifests(IResource resource) {
        if (resource.getType() == 4) {
            IProject project = resource.getProject();
            if (!DependentManifestUtils.checkManifest((IProject)project)) {
                return;
            }
            IPath manifestLocation = DependentManifestUtils.getManifestRawLocation((IProject)project);
            IProject parentProject = DependentManifestUtils.readManifest((IProject)project, (IProgressMonitor)new NullProgressMonitor());
            if (manifestLocation != null) {
                this.manifests.put(manifestLocation.toFile(), parentProject);
            }
        }
    }

    private void fillRemovedLanguagesMap(IResourceDelta eventDelta, Map<IProject, List<String>> removedLanguagesMap) throws CoreException {
        eventDelta.accept(delta -> {
            IPath path;
            IResource resource = delta.getResource();
            if (resource.getType() == 1 && (delta.getKind() & 2) != 0 && "tlx".equals(resource.getFileExtension()) && (path = resource.getProjectRelativePath()).segmentCount() == 4 && path.segment(0).equalsIgnoreCase(FOLDER_SRC) && path.segment(1).equalsIgnoreCase(FOLDER_LANGUAGES)) {
                IProject project = resource.getProject();
                IPath manifestLocation = DependentManifestUtils.getManifestRawLocation((IProject)project);
                IProject parentProject = this.manifests.remove(manifestLocation.toFile());
                List removedLanguagesList = removedLanguagesMap.computeIfAbsent(parentProject, newProject -> new ArrayList());
                String resourceName = resource.getName();
                String languageName = resourceName.substring(0, resourceName.lastIndexOf(46));
                removedLanguagesList.add(languageName);
            }
            return true;
        });
    }

    private void removeLanguages(Map<IProject, List<String>> removedLanguagesMap) {
        for (final Map.Entry<IProject, List<String>> entry : removedLanguagesMap.entrySet()) {
            IBmModel model = this.modelManager.getModel(entry.getKey());
            if (model == null || model.isDisposed() || !entry.getKey().isAccessible()) continue;
            model.execute((IBmTask)new AbstractBmTask<Void>("Removing obsolete languages from project " + entry.getKey().getName()){

                /*
                 * WARNING - void declaration
                 */
                public Void execute(IBmTransaction transaction, IProgressMonitor progressMonitor) {
                    IBmObject configurationObject = transaction.getTopObjectByFqn("Configuration");
                    IBmObject iBmObject = configurationObject;
                    if (iBmObject instanceof Configuration) {
                        void configuration;
                        Configuration configuration2 = (Configuration)iBmObject;
                        Configuration cfr_ignored_0 = (Configuration)iBmObject;
                        EList configurationLanguages = configuration.getLanguages();
                        List languageNamesToDelete = (List)entry.getValue();
                        List<Language> deleteList = configurationLanguages.stream().filter(language -> languageNamesToDelete.contains(language.getName())).toList();
                        for (Language deletedLanguage : deleteList) {
                            configurationLanguages.remove((Object)deletedLanguage);
                        }
                    }
                    return null;
                }
            });
        }
    }
}

