/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.tlx.importer;

import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmPlatformTransaction;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.provider.BmContentImportSupport;
import com._1c.g5.v8.dt.core.provider.ImportException;
import com._1c.g5.v8.dt.core.provider.TransactionalBmContentImporter;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassFactory;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.lang.model.util.LanguageUtil;
import com.e1c.langtool.v8.dt.md.settings.MdFeatureSettings;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageManifest;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

@Singleton
public class TranslateLanguageDataContentImporter
extends TransactionalBmContentImporter {
    public static final String TLX_EXT = "tlx";
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager translationStorageManager;
    @Inject
    private ITranslationFeatureKeyProvider translationFeatureKeyProvider;
    @Inject
    private IResourceLookup resourceLookup;

    @Inject
    public TranslateLanguageDataContentImporter(IBmModelManager bmModelManager, IQualifiedNameFilePathConverter qualifiedNameFilePathConverter) {
        super(bmModelManager);
    }

    public boolean supports(IPath path) {
        String ext = path.getFileExtension();
        return ext != null && TLX_EXT.equals(ext) && path.segmentCount() == 4 && "src".equals(path.segment(0)) && "Languages".equals(path.segment(1));
    }

    public byte[] handleResourceCreationOrModification(IBmPlatformTransaction transaction, IBmNamespace namespace, IDtProject project, IPath path, InputStream content, boolean fullOverride) {
        BmContentImportSupport.NonCloseableHashingInputStream hashingIn = new BmContentImportSupport.NonCloseableHashingInputStream(Hashing.sha256(), content);
        IBmObject object = transaction.getTopObjectByFqn(namespace, "Configuration");
        if (object instanceof Configuration) {
            Configuration configuration = (Configuration)object;
            if (project.getWorkspaceProject() != null) {
                this.doImportTranslateLanguage(configuration, project.getWorkspaceProject(), path);
            }
        }
        try {
            while (hashingIn.read() != -1) {
            }
        }
        catch (IOException e) {
            throw new ImportException(String.format("Read error\nProject: %s\nLocation: %s", project.getName(), path.toString()), (Throwable)e);
        }
        return hashingIn.hash().asBytes();
    }

    public void handleResourceDeletion(IBmPlatformTransaction transaction, IBmNamespace namespace, IDtProject project, IPath path) {
        IBmObject object = transaction.getTopObjectByFqn(namespace, "Configuration");
        if (object instanceof Configuration) {
            Configuration configuration = (Configuration)object;
            if (project.getWorkspaceProject() != null) {
                this.doImportTranslateLanguage(configuration, project.getWorkspaceProject(), path);
            }
        }
    }

    public void doImportTranslateLanguage(Configuration configuration, IProject project, IPath path) {
        Language language2;
        IFile languageFile = project.getFile(path);
        if (!languageFile.exists()) {
            String languageName = path.removeFileExtension().lastSegment();
            Optional<Language> lanuage = configuration.getLanguages().stream().filter(l -> languageName != null && languageName.equals(l.getName())).findFirst();
            if (lanuage.isPresent()) {
                configuration.getLanguages().remove((Object)lanuage.get());
            }
            return;
        }
        V8TranslateLanguage translateLanguage = TranslateLanguageManifest.load((IFile)languageFile);
        String translateLanguageName = translateLanguage.getName();
        List matchedConfigurationLanguages = configuration.getLanguages().stream().filter(language -> translateLanguageName.equals(language.getName())).collect(Collectors.toList());
        IFile file = this.resourceLookup.getPlatformResource((EObject)configuration);
        String defaultLanguageCode = "";
        if (configuration.getDefaultLanguage() != null) {
            language2 = configuration.getDefaultLanguage();
            if (language2.eIsProxy()) {
                String fragment = EcoreUtil.getURI((EObject)language2).fragment();
                String defaultLanguageName = this.extractLanguageNameFromUriFragment(fragment);
                EList languages = configuration.getLanguages();
                for (Language lang : languages) {
                    if (!lang.getName().equals(defaultLanguageName)) continue;
                    language2 = lang;
                    break;
                }
            }
            defaultLanguageCode = language2.getLanguageCode();
        }
        if (matchedConfigurationLanguages.isEmpty()) {
            language2 = MdClassFactory.eINSTANCE.createLanguage();
            LanguageUtil.copyLanguageContent((V8TranslateLanguage)translateLanguage, (Language)language2);
            configuration.getLanguages().add((Object)language2);
            this.appendLanguageSynonym(language2, file, defaultLanguageCode);
        } else {
            for (Language matchedLanguage : matchedConfigurationLanguages) {
                LanguageUtil.copyLanguageContent((V8TranslateLanguage)translateLanguage, (Language)matchedLanguage);
                this.appendLanguageSynonym(matchedLanguage, file, defaultLanguageCode);
            }
        }
    }

    private void appendLanguageSynonym(Language language, IFile file, String defaultLanguageCode) {
        IProject project = file.getProject();
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        StorageID storageId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
        ITranslationStorageProvider.Storage storage = this.translationStorageManager.getStorage(project, storageId);
        if (storage instanceof ITranslationStorageProvider.ContextStorage) {
            FeatureKey featureKey = this.translationFeatureKeyProvider.getFeatureKey((EObject)language, (FeatureSettings)MdFeatureSettings.Literals.MD_OBJECT__SYNONYM);
            ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)MdFeatureSettings.Literals.MD_OBJECT__SYNONYM, (String)language.getSynonym().get((Object)defaultLanguageCode));
            for (TranslateLanguage translateLanguage : translating.getInterfaceLanguages()) {
                String translation = ((ITranslationStorageProvider.ContextStorage)storage).getTranslation((ContextTranslationKey)key, translateLanguage);
                if (!StringUtils.isNotEmpty((String)translation)) continue;
                language.getSynonym().put((Object)translateLanguage.getLanguageCode(), (Object)translation);
            }
        }
    }

    private String extractLanguageNameFromUriFragment(String fragment) {
        String preffix = "::Language.";
        int index = fragment.indexOf("::Language.");
        if (index > -1 && fragment.length() > index + "::Language.".length()) {
            return fragment.substring(index + "::Language.".length());
        }
        return null;
    }
}

