/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.core.ext;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.core.ext.IBmContentImporterExtension;
import com.e1c.langtool.v8.dt.core.ext.IBmObjectExporterExtension;
import com.e1c.langtool.v8.dt.core.ext.IDataContentImporterExtension;
import com.e1c.langtool.v8.dt.core.ext.IResourceContentImporterExtension;
import com.e1c.langtool.v8.dt.internal.core.ext.ExtPlugin;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;

@Singleton
public class ExtensionRegistry {
    public static final String EXPORTER_EXTENSION_POIN_ID = "com.e1c.langtool.v8.dt.core.ext.bmContentExporterExtension";
    public static final String IMPORTER_EXTENSION_POIN_ID = "com.e1c.langtool.v8.dt.core.ext.bmContentImporterExtension";
    private static final String ATT_CLASS = "class";
    private Map<EClass, Collection<IBmObjectExporterExtension>> exporters;
    private Map<EClass, Collection<IBmContentImporterExtension>> importers;

    public Collection<IBmObjectExporterExtension> allExporters() {
        this.checkLoadExporters();
        return this.exporters.entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream()).collect(Collectors.toSet());
    }

    public Collection<IBmObjectExporterExtension> getExporters(EClass eClass) {
        this.checkLoadExporters();
        return this.exporters.entrySet().stream().filter(e -> ((EClass)e.getKey()).isSuperTypeOf(eClass)).flatMap(e -> ((Collection)e.getValue()).stream()).collect(Collectors.toSet());
    }

    public Collection<IBmContentImporterExtension> allImporters() {
        this.checkLoadImporters();
        return this.importers.entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream()).collect(Collectors.toSet());
    }

    public Collection<IResourceContentImporterExtension> getResourceImporters(EClass eClass) {
        this.checkLoadImporters();
        return this.importers.entrySet().stream().filter(e -> ((EClass)e.getKey()).isSuperTypeOf(eClass)).flatMap(e -> ((Collection)e.getValue()).stream()).filter(IResourceContentImporterExtension.class::isInstance).map(IResourceContentImporterExtension.class::cast).collect(Collectors.toList());
    }

    public Collection<IDataContentImporterExtension> getDataImporters(EClass eClass) {
        this.checkLoadImporters();
        return this.importers.entrySet().stream().filter(IDataContentImporterExtension.class::isInstance).filter(e -> ((EClass)e.getKey()).isSuperTypeOf(eClass)).map(IDataContentImporterExtension.class::cast).collect(Collectors.toList());
    }

    public Collection<IResourceContentImporterExtension> getResourceImporters(IPath path) {
        this.checkLoadImporters();
        if (StringUtils.isNullOrEmpty((String)path.getFileExtension())) {
            return Collections.emptyList();
        }
        String fileExtension = path.getFileExtension();
        return this.importers.entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream()).filter(IResourceContentImporterExtension.class::isInstance).map(IResourceContentImporterExtension.class::cast).filter(i -> i.beforeImportFileExtensions().contains(fileExtension)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkLoadExporters() {
        if (this.exporters != null) return;
        Class<ExtensionRegistry> clazz = ExtensionRegistry.class;
        synchronized (ExtensionRegistry.class) {
            HashMap builder = Maps.newHashMap();
            for (IBmObjectExporterExtension exporter : this.loadExporters()) {
                for (EClass eClass : exporter.targets()) {
                    Collection collection = builder.computeIfAbsent(eClass, c -> Sets.newLinkedHashSet());
                    collection.add(exporter);
                }
            }
            this.exporters = ImmutableMap.copyOf((Map)builder);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkLoadImporters() {
        if (this.importers != null) return;
        Class<ExtensionRegistry> clazz = ExtensionRegistry.class;
        synchronized (ExtensionRegistry.class) {
            HashMap builder = Maps.newHashMap();
            for (IBmContentImporterExtension importer : this.loadImporters()) {
                for (EClass eClass : importer.targets()) {
                    Collection collection = builder.computeIfAbsent(eClass, c -> Sets.newLinkedHashSet());
                    collection.add(importer);
                }
            }
            this.importers = ImmutableMap.copyOf((Map)builder);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private Collection<IBmContentImporterExtension> loadImporters() {
        ArrayList importers = Lists.newArrayList();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(IMPORTER_EXTENSION_POIN_ID);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement configElement = elements[i];
            try {
                IBmContentImporterExtension e = (IBmContentImporterExtension)configElement.createExecutableExtension(ATT_CLASS);
                importers.add(e);
            }
            catch (CoreException e) {
                ExtPlugin.logError(e);
            }
            ++i;
        }
        return importers;
    }

    private Collection<IBmObjectExporterExtension> loadExporters() {
        ArrayList importers = Lists.newArrayList();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPORTER_EXTENSION_POIN_ID);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement configElement = elements[i];
            try {
                IBmObjectExporterExtension e = (IBmObjectExporterExtension)configElement.createExecutableExtension(ATT_CLASS);
                importers.add(e);
            }
            catch (CoreException e) {
                ExtPlugin.logError(e);
            }
            ++i;
        }
        return importers;
    }
}

