/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.core.ext;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.provider.IResourceContentExporterExtension;
import com._1c.g5.v8.dt.core.provider.IResourceContentExporterExtensionManager;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.core.ext.ExtensionRegistry;
import com.e1c.langtool.v8.dt.core.ext.IBmObjectExporterExtension;
import com.e1c.langtool.v8.dt.internal.core.ext.ExtPlugin;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;

@LifecycleService(name="BmContentExporterExtension")
@Singleton
public class BmContentExporterExtension
implements IResourceContentExporterExtension {
    private final ITranslatingProjectManager translatingProjectManager;
    private final ExtensionRegistry extensionRegistry;
    private final IResourceContentExporterExtensionManager resourceContentExporterExtensionManager;
    private boolean initialized = false;

    @Inject
    public BmContentExporterExtension(ITranslatingProjectManager translatingProjectManager, ExtensionRegistry extensionRegistry, IResourceContentExporterExtensionManager resourceContentExporterExtensionManager) {
        this.translatingProjectManager = translatingProjectManager;
        this.extensionRegistry = extensionRegistry;
        this.resourceContentExporterExtensionManager = resourceContentExporterExtensionManager;
    }

    public void afterExport(IDtProject dtProject, IBmObject bmObject, IBmObject clone, IFile file, Map<IFile, byte[]> exportedExtraFiles) {
        if (dtProject.getWorkspaceProject() == null || !this.translatingProjectManager.getProject(dtProject.getWorkspaceProject()).isTranslating()) {
            return;
        }
        Collection<IBmObjectExporterExtension> exporters = this.extensionRegistry.getExporters(bmObject.eClass());
        for (IBmObjectExporterExtension exporterExt : exporters) {
            try {
                exporterExt.afterExport(dtProject, bmObject, clone, file, exportedExtraFiles);
            }
            catch (Exception e) {
                ExtPlugin.logError(e);
            }
        }
    }

    public void beforeExport(IDtProject dtProject, IBmObject bmObject, IBmObject clone, IFile file, Map<IFile, byte[]> exportedExtraFiles) {
        if (dtProject.getWorkspaceProject() == null || !this.translatingProjectManager.getProject(dtProject.getWorkspaceProject()).isTranslating()) {
            return;
        }
        Collection<IBmObjectExporterExtension> exporters = this.extensionRegistry.getExporters(bmObject.eClass());
        for (IBmObjectExporterExtension exporterExt : exporters) {
            try {
                exporterExt.beforeExport(dtProject, bmObject, clone, file, exportedExtraFiles);
            }
            catch (Exception e) {
                ExtPlugin.logError(e);
            }
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.resourceContentExporterExtensionManager.registerExtension((IResourceContentExporterExtension)this);
    }
}

