/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.core.ext;

import com._1c.g5.v8.bm.core.IBmEngine;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.provider.IResourceContentImporterExtensionManager;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.core.ext.ExtensionRegistry;
import com.e1c.langtool.v8.dt.core.ext.IResourceContentImporterExtension;
import com.e1c.langtool.v8.dt.internal.core.ext.ExtPlugin;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

@LifecycleService(name="BmContentImporterExtension")
@Singleton
public class BmContentImporterExtension
implements com._1c.g5.v8.dt.core.provider.IResourceContentImporterExtension {
    private final ITranslatingProjectManager translatingProjectManager;
    private final IBmModelManager bmModelManager;
    private final ExtensionRegistry extensionRegistry;
    private final IResourceContentImporterExtensionManager resourceContentImporterExtensionManager;
    private boolean initialized = false;

    @Inject
    public BmContentImporterExtension(ITranslatingProjectManager translatingProjectManager, IBmModelManager bmModelManager, ExtensionRegistry extensionRegistry, IResourceContentImporterExtensionManager resourceContentImporterExtensionManager) {
        this.translatingProjectManager = translatingProjectManager;
        this.bmModelManager = bmModelManager;
        this.extensionRegistry = extensionRegistry;
        this.resourceContentImporterExtensionManager = resourceContentImporterExtensionManager;
    }

    public void afterImport(IBmObject importedObject, IBmEngine engine, Resource resource, IPath path) {
        IDtProject project = this.bmModelManager.getDtProject(engine.getId());
        if (project.getWorkspaceProject() == null || !this.translatingProjectManager.getProject(project.getWorkspaceProject()).isTranslating()) {
            return;
        }
        IBmTransaction transaction = engine.getCurrentTransaction();
        if (transaction == null) {
            this.bmModelManager.executeReadWriteTask(project, tr -> {
                this.doAfterImport((IBmObject)tr.toTransactionObject((EObject)importedObject), engine, tr, resource, path);
                return null;
            });
        } else {
            this.doAfterImport((IBmObject)transaction.toTransactionObject((EObject)importedObject), engine, transaction, resource, path);
        }
    }

    public void beforeImport(IBmEngine engine, Resource resource, IPath path) {
        IDtProject project = this.bmModelManager.getDtProject(engine.getId());
        if (project == null || project.getWorkspaceProject() == null || !this.translatingProjectManager.getProject(project.getWorkspaceProject()).isTranslating()) {
            return;
        }
        IBmTransaction transaction = engine.getCurrentTransaction();
        if (transaction == null) {
            this.bmModelManager.executeReadWriteTask(project, tr -> {
                this.doBeforeImport(engine, tr, resource, path);
                return null;
            });
        } else {
            this.doBeforeImport(engine, transaction, resource, path);
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.resourceContentImporterExtensionManager.registerExtension((com._1c.g5.v8.dt.core.provider.IResourceContentImporterExtension)this);
    }

    private void doAfterImport(IBmObject importedObject, IBmEngine engine, IBmTransaction transaction, Resource resource, IPath path) {
        Collection<IResourceContentImporterExtension> importers = this.extensionRegistry.getResourceImporters(importedObject.eClass());
        for (IResourceContentImporterExtension importer : importers) {
            try {
                importer.afterImport(engine, transaction, resource, path, importedObject);
            }
            catch (Exception e) {
                if (e instanceof CancellationException) continue;
                ExtPlugin.logError(e);
            }
        }
    }

    private void doBeforeImport(IBmEngine engine, IBmTransaction transaction, Resource resource, IPath path) {
        Collection<IResourceContentImporterExtension> importers = this.extensionRegistry.getResourceImporters(path);
        for (IResourceContentImporterExtension importer : importers) {
            try {
                importer.beforeImport(engine, transaction, resource, path);
            }
            catch (Exception e) {
                ExtPlugin.logError(e);
            }
        }
    }
}

