/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.expressions;

import com._1c.g5.v8.dt.core.platform.V8ParametersStringParser;
import com._1c.g5.v8.dt.dcs.expressions.model.Expression;
import com._1c.g5.v8.dt.dcs.expressions.model.Function;
import com._1c.g5.v8.dt.dcs.expressions.model.StringLiteral;
import com.e1c.langtool.common.StringUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public final class DcsExprUtils {
    public static final String DOUBLE_QUOTE = "\"\"";
    public static final String QUTE = "\"";
    public static final String DCS_EXPR_FILE_EXT = "dcsexpr";
    private static final String NLS_STRING = "nstr";
    private static final String NLS_STRING_RU = "\u043d\u0441\u0442\u0440";

    public static String getStringLiteralValue(StringLiteral object) {
        String value = object.getValue();
        if (StringUtils.isNullOrEmpty((String)value)) {
            return value;
        }
        return value.substring(1, value.length() - 1).replace(DOUBLE_QUOTE, QUTE);
    }

    public static String formatStringLiteralValue(String value) {
        if (value != null) {
            return QUTE + value.replaceAll(QUTE, DOUBLE_QUOTE) + QUTE;
        }
        return null;
    }

    public static boolean isNls(EObject object) {
        Function parent;
        if (object instanceof Function) {
            return DcsExprUtils.isNls((Function)object);
        }
        if (object instanceof StringLiteral && DcsExprUtils.isNls(parent = (Function)EcoreUtil2.getContainerOfType((EObject)object, Function.class)).booleanValue() && !parent.getParameters().isEmpty()) {
            return ((Expression)parent.getParameters().get(0)).equals(object);
        }
        return false;
    }

    public static Boolean isNls(Function func) {
        if (func == null) {
            return false;
        }
        String name = func.getName().getContent();
        if (name != null && (name.equalsIgnoreCase(NLS_STRING_RU) || name.equalsIgnoreCase(NLS_STRING))) {
            return true;
        }
        return false;
    }

    public static Map<String, String> getNlsLocalStrings(EObject object) {
        if (DcsExprUtils.isNls(object)) {
            Expression param;
            EList params;
            Function inv = null;
            if (object instanceof Function) {
                inv = (Function)object;
            } else if (object instanceof StringLiteral && object.eContainer() instanceof Function) {
                inv = (Function)object.eContainer();
            }
            if (inv != null && !(params = inv.getParameters()).isEmpty() && (param = (Expression)params.get(0)) instanceof StringLiteral) {
                String fullString = DcsExprUtils.getStringLiteralValue((StringLiteral)param);
                V8ParametersStringParser parser = new V8ParametersStringParser(fullString);
                return parser.getStatus().isOK() ? parser.getParameters() : Maps.newHashMap();
            }
        }
        return Maps.newHashMap();
    }

    public static String[] getStringLiteralListExpressionParts(StringLiteral literal) {
        String literalText = DcsExprUtils.getStringLiteralValue(literal);
        ArrayList<String> result = new ArrayList<String>();
        int bracketStack = 0;
        int stringStack = 0;
        int position = 0;
        int i = 0;
        while (i < literalText.length()) {
            char c = literalText.charAt(i);
            switch (c) {
                case '(': {
                    if (stringStack != 0) break;
                    ++bracketStack;
                    break;
                }
                case ')': {
                    if (stringStack != 0) break;
                    --bracketStack;
                    break;
                }
                case '\"': {
                    if (stringStack == 0) {
                        ++stringStack;
                    }
                    if (stringStack <= 0) break;
                    --stringStack;
                    break;
                }
                case ',': {
                    if (stringStack != 0 || bracketStack != 0) break;
                    String part = literalText.substring(position, i);
                    result.add(part);
                    position = i + 1;
                    break;
                }
            }
            ++i;
        }
        if (position < literalText.length()) {
            String part = literalText.substring(position);
            result.add(part);
        }
        return result.toArray(new String[0]);
    }

    private DcsExprUtils() throws IllegalAccessException {
        throw new IllegalAccessException("Utility class");
    }
}

