/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.expressions;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com._1c.g5.v8.dt.dcs.expressions.model.Function;
import com._1c.g5.v8.dt.dcs.expressions.model.SinglePartName;
import com._1c.g5.v8.dt.dcs.expressions.model.StringLiteral;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.dcs.expressions.DcsExprProcessor;
import com.e1c.langtool.v8.dt.dcs.expressions.DcsExprUtils;
import com.e1c.langtool.v8.dt.dcs.expressions.StringLiteralInternalizeTokenProvider;
import com.e1c.langtool.v8.dt.dcs.expressions.settings.DcsExprFeatureSettings;
import com.e1c.langtool.v8.dt.internal.dcs.expressions.ExprPlugin;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.util.CancelIndicator;

public class ExpressionsFeaturesCollector
extends DcsExprProcessor
implements FeatureValueCollector {
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IFeatureSettingsService settingsService;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IComputedNameService computedNameService;
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private StringLiteralInternalizeTokenProvider stringLiteralProvider;
    @Inject
    private IDependentModelProvider dependentModelProvider;
    private final ICollectingParameters parameters;
    private CollectingContext context;
    private final BiConsumer<Object, FeatureValue> addAction;
    private String defaultLanguageCode;
    private IFile resourceFile;

    public static ExpressionsFeaturesCollector create(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isNotNull((Object)object, (String)"Object cannot be null");
        ExpressionsFeaturesCollector collector = new ExpressionsFeaturesCollector(object, parameters, addAction);
        ExprPlugin.getDefault().getInjector().injectMembers((Object)collector);
        return collector;
    }

    public ExpressionsFeaturesCollector(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        super(object);
        Assert.isLegal((parameters != null ? 1 : 0) != 0, (String)"Parameters cannot be null.");
        this.parameters = parameters;
        this.addAction = addAction;
    }

    @Override
    protected <T extends EObject> void doProcess(T object, Class<T> clazz) {
        if (object == null) {
            return;
        }
        if (object instanceof SinglePartName && object.eContainer() instanceof Function) {
            return;
        }
        if (object instanceof StringLiteral) {
            this.doProcessInternal((StringLiteral)object, this.monitor);
        } else {
            FeaturesCollectorUtil.collectFeatures(object, (CollectingContext)this.getContext(), (IProgressMonitor)this.monitor);
        }
    }

    private void doProcessInternal(StringLiteral object, IProgressMonitor monitor) {
        if (DcsExprUtils.isNls((EObject)object)) {
            this.collectLiteralNstr(object, monitor);
        } else if (!this.isEnumStringLiteral(object)) {
            this.collectLiteralString(object, monitor);
            if (this.isExpressionStringLiteral(object)) {
                if (this.isExpressionListStringLiteral(object)) {
                    this.collectExpressionListFromLiteralString(object, monitor);
                } else {
                    this.collectExpressionFromLiteralString(object, monitor);
                }
            }
        }
    }

    private boolean isEnumStringLiteral(StringLiteral object) {
        if (!(object.eContainer() instanceof Function)) {
            return false;
        }
        Function function = (Function)object.eContainer();
        return this.stringLiteralProvider.getLiteralEnumValue(function, object, false) != null || this.stringLiteralProvider.getLiteralEnumValue(function, object, true) != null;
    }

    private boolean isExpressionStringLiteral(StringLiteral object) {
        if (!(object.eContainer() instanceof Function)) {
            return false;
        }
        Function function = (Function)object.eContainer();
        return this.stringLiteralProvider.isExpressionLiteral(function, object);
    }

    private boolean isExpressionListStringLiteral(StringLiteral object) {
        if (!(object.eContainer() instanceof Function)) {
            return false;
        }
        Function function = (Function)object.eContainer();
        return this.stringLiteralProvider.isExpressionListLiteral(function, object);
    }

    private void collectLiteralNstr(StringLiteral literal, IProgressMonitor monitor) {
        boolean hasValue;
        if (!this.parameters.isCollectInterfaceStrings()) {
            return;
        }
        Map<String, String> nls = DcsExprUtils.getNlsLocalStrings((EObject)literal);
        if (nls.isEmpty() || StringUtils.isNullOrEmpty((String)nls.get(this.getDefaultLanguageCode()))) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)literal, (FeatureSettings)DcsExprFeatureSettings.Literals.NSTR_STRING_LITERAL__VALUE);
        String nlsString = nls.get(this.getDefaultLanguageCode());
        boolean isComputedValue = false;
        PersistableFeatureValue featureValue = new PersistableFeatureValue(this.getResourceFile(), featureKey, (FeatureSettings)DcsExprFeatureSettings.Literals.NSTR_STRING_LITERAL__VALUE, nlsString, isComputedValue);
        FeaturesCollectorUtil.fillLocalStrings((Map)featureValue.getLocalStrings(), nls, (Collection)this.parameters.getLanguages());
        if (this.parameters.isKeepLanguagesMode()) {
            featureValue.getLocalStrings().clear();
            for (Map.Entry<String, String> entry : nls.entrySet()) {
                featureValue.getLocalStrings().putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        boolean bl = hasValue = StringUtils.isNotEmpty((String)nlsString) || !featureValue.getLocalStrings().isEmpty();
        if (!this.parameters.isCollectEmptyValue() && !hasValue) {
            return;
        }
        if (this.parameters.isCollectInterfaceStrings()) {
            this.addAction.accept(literal, (FeatureValue)featureValue);
        }
        if (this.parameters.isCollectModelStrings() && hasValue) {
            String[] params = Utils.getParamsFromNls((String)nlsString);
            int i = 0;
            while (i < params.length) {
                String param = params[i];
                if (!StringUtils.isNullOrEmpty((String)param)) {
                    this.collectStringSingleParam(literal, featureKey, isComputedValue, nlsString, param);
                    isComputedValue = true;
                }
                ++i;
            }
        }
        subMonitor.worked(1);
    }

    private void collectLiteralString(StringLiteral literal, IProgressMonitor monitor) {
        if (!this.parameters.isCollectModelStrings()) {
            return;
        }
        String value = DcsExprUtils.getStringLiteralValue(literal);
        if (StringUtils.isBlank((String)value) && !this.parameters.isCollectEmptyValue()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        String[] params = Utils.getParamsFromNls((String)value);
        boolean isComputedValue = false;
        if (DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE.isModel() && this.getContext().getComputedNameService() != null) {
            isComputedValue = this.getContext().getComputedNameService().isComputedString((EObject)literal, DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE);
        }
        FeatureKey featureKey = this.context.getFeatureKeyProvider().getFeatureKey((EObject)literal, (FeatureSettings)DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE);
        if (params.length == 1) {
            this.collectStringSingleParam(literal, featureKey, isComputedValue, value, params[0]);
            isComputedValue = true;
        }
        if (!TranslationUtils.isValidValueForCollectModelType((boolean)isComputedValue, (boolean)false, (boolean)false, (ICollectingParameters.CollectModelType)this.getContext().getParameters().getCollectModelType())) {
            return;
        }
        PersistableFeatureValue featureValue = new PersistableFeatureValue(this.getResourceFile(), featureKey, (FeatureSettings)DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE, value, isComputedValue);
        this.getContext().getAddAction().accept(literal, featureValue);
        subMonitor.worked(1);
    }

    private void collectStringSingleParam(StringLiteral literal, FeatureKey literalFeatureKey, boolean isLiteralComputedValue, String literalValue, String param) {
        if (StringUtils.isNotEmpty((String)param)) {
            HashMap nls = Maps.newHashMap();
            FeatureKey featureKey = literalFeatureKey.skipLast(2);
            PersistableFeatureValue paramValue = new PersistableFeatureValue(this.getResourceFile(), featureKey.append(param).append("Param"), DcsExprFeatureSettings.Literals.STRING_LITERAL__PARAM, param, isLiteralComputedValue);
            if (StringUtils.isNotEmpty((String)literalValue)) {
                nls.put(this.getDefaultLanguageCode(), param);
            }
            FeaturesCollectorUtil.fillLocalStrings((FeatureValue)paramValue, (Map)nls, (Collection)this.parameters.getLanguages());
            if (TranslationUtils.isValidValueForCollectModelType((boolean)paramValue.isComputedValue(), (boolean)paramValue.isUnknown(), (boolean)paramValue.isTag(), (ICollectingParameters.CollectModelType)this.parameters.getCollectModelType())) {
                this.addAction.accept(literal, (FeatureValue)paramValue);
            }
        }
    }

    private void collectExpressionFromLiteralString(StringLiteral object, IProgressMonitor monitor) {
        IPath basePath = this.getResourceFile().getProjectRelativePath().removeFileExtension().addFileExtension("dcsexpr");
        Expressions expression = (Expressions)this.dependentModelProvider.getDependentModel((EObject)object, DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE.getEFeature(), basePath, this::getStringLiteralText, (CancelIndicator)new MonitorBasedCancelIndicator(monitor));
        try {
            TranslationSource source = TranslationUtils.getTranslationSource((Object)expression);
            if (source != null) {
                this.getContext().getCollectingService().forEachCollected(source, this.getContext().getParameters(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor), this.getContext().getAddAction());
            }
        }
        finally {
            this.dependentModelProvider.unload((EObject)expression);
        }
    }

    private void collectExpressionListFromLiteralString(StringLiteral object, IProgressMonitor monitor) {
        IPath basePath = this.getResourceFile().getProjectRelativePath().removeFileExtension().addFileExtension("dcsexpr");
        String[] parts = DcsExprUtils.getStringLiteralListExpressionParts(object);
        MonitorBasedCancelIndicator cancelIndicator = new MonitorBasedCancelIndicator(monitor);
        int i = 0;
        while (i < parts.length) {
            String part = parts[i];
            Expressions expression = (Expressions)this.dependentModelProvider.getDependentModel((EObject)object, DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE.getEFeature(), basePath, (s, f) -> part, (CancelIndicator)cancelIndicator);
            try {
                TranslationSource source = TranslationUtils.getTranslationSource((Object)expression);
                if (source != null) {
                    this.getContext().getCollectingService().forEachCollected(source, this.getContext().getParameters(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor), this.getContext().getAddAction());
                }
            }
            finally {
                this.dependentModelProvider.unload((EObject)expression);
            }
            ++i;
        }
    }

    private CollectingContext getContext() {
        if (this.context == null) {
            this.context = new CollectingContext(this.parameters, this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, this.getDefaultLanguageCode(), this.addAction, this.getResourceFile());
        }
        return this.context;
    }

    private String getDefaultLanguageCode() {
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = "";
            Language language = this.v8ProjectManager.getProject(this.object).getDefaultLanguage();
            if (language != null) {
                this.defaultLanguageCode = language.getLanguageCode();
            }
        }
        return this.defaultLanguageCode;
    }

    private IFile getResourceFile() {
        if (this.resourceFile == null) {
            EObject root = this.object;
            while (root != null && root.eResource() != null && !root.eResource().getContents().isEmpty()) {
                EObject parent = this.dependentModelProvider.getParent(root = (EObject)root.eResource().getContents().get(0));
                if (parent == null) break;
                root = parent;
            }
            this.resourceFile = this.resourceLookup.getPlatformResource(root);
        }
        return this.resourceFile;
    }

    private String getStringLiteralText(EObject object, EStructuralFeature feature) {
        return DcsExprUtils.getStringLiteralValue((StringLiteral)object);
    }
}

