/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.expressions;

import com._1c.g5.v8.dt.dcs.expressions.ExpressionsTerms;
import com._1c.g5.v8.dt.dcs.expressions.functions.ExpressionsFunctionsProvider;
import com._1c.g5.v8.dt.dcs.expressions.model.Function;
import com._1c.g5.v8.dt.dcs.expressions.model.StringLiteral;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.dcs.expressions.DcsExprUtils;
import com.google.inject.Singleton;

@Singleton
public class StringLiteralInternalizeTokenProvider {
    public static final String[] EVAL_EXPRESSION_SORT_RU = new String[]{ExpressionsTerms.kDCSExprTerm_OrderAsc[1], ExpressionsTerms.kDCSExprTerm_OrderDesc[1], ExpressionsTerms.kDCSExprTerm_OrderAutoOrder[1]};
    public static final String[] EVAL_EXPRESSION_SORT_EN = new String[]{ExpressionsTerms.kDCSExprTerm_OrderAsc[0], ExpressionsTerms.kDCSExprTerm_OrderDesc[0], ExpressionsTerms.kDCSExprTerm_OrderAutoOrder[0]};
    private static final String[] EVAL_EXPRESSION_BEGIN_TYPES_RU = new String[]{ExpressionsTerms.kDCSExprTerm_RecordsPosition_First[1], ExpressionsTerms.kDCSExprTerm_RecordsPosition_Last[1], ExpressionsTerms.kDCSExprTerm_RecordsPosition_Previous[1], ExpressionsTerms.kDCSExprTerm_RecordsPosition_Next[1], ExpressionsTerms.kDCSExprTerm_RecordsPosition_Current[1]};
    private static final String[] EVAL_EXPRESSION_BEGIN_TYPES_EN = new String[]{ExpressionsTerms.kDCSExprTerm_RecordsPosition_First[0], ExpressionsTerms.kDCSExprTerm_RecordsPosition_Last[0], ExpressionsTerms.kDCSExprTerm_RecordsPosition_Previous[0], ExpressionsTerms.kDCSExprTerm_RecordsPosition_Next[0], ExpressionsTerms.kDCSExprTerm_RecordsPosition_Current[0]};

    public boolean isExpressionLiteral(Function function, StringLiteral literal) {
        int index = function.getParameters().indexOf((Object)literal);
        if (index == -1) {
            return false;
        }
        String parameterValue = DcsExprUtils.getStringLiteralValue(literal);
        if (StringUtils.isNullOrEmpty((String)parameterValue)) {
            return false;
        }
        String name = function.getName().getFullContent();
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_Eval)) {
            return index == 0;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_EvalExpression)) {
            return index == 0 || (index == 3 || index == 4) && this.getStringIndex(parameterValue, ExpressionsTerms.kDCSExprTerm_RecordsPosition_BoundaryValue, true) > -1 || index == 5 || index == 6;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_GetURL)) {
            return index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_RecordsPosition_BoundaryValue)) {
            return index == 0;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_EvalExpressionWithGroupByArray) || this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_EvalExpressionWithGroupByValueTable)) {
            return index >= 0 && index < 4;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_GroupProcessing)) {
            return index >= 0 && index < 3;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_ClassificationABC)) {
            return index == 0 || index == 3;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_GroupBy)) {
            return index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_GetPart)) {
            return index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_Order)) {
            return index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_Rank)) {
            return index >= 0 && index < 3;
        }
        return false;
    }

    public boolean isExpressionListLiteral(Function function, StringLiteral literal) {
        int index = function.getParameters().indexOf((Object)literal);
        if (index == -1) {
            return false;
        }
        String parameterValue = DcsExprUtils.getStringLiteralValue(literal);
        if (StringUtils.isNullOrEmpty((String)parameterValue)) {
            return false;
        }
        String name = function.getName().getFullContent();
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_EvalExpression)) {
            return index == 5 || index == 6;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_EvalExpressionWithGroupByArray)) {
            return index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_EvalExpressionWithGroupByValueTable)) {
            return index == 0 || index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_GroupProcessing)) {
            return index == 0 || index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_GroupBy)) {
            return index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_GetPart)) {
            return index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_Order)) {
            return index == 1;
        }
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_Rank)) {
            return index == 0 || index == 1;
        }
        return false;
    }

    public String getLiteralEnumValue(Function function, StringLiteral literal, ScriptVariant scriptVariant) {
        return this.getLiteralEnumValue(function, literal, ScriptVariant.RUSSIAN == scriptVariant);
    }

    public String getLiteralEnumValue(Function function, StringLiteral literal, boolean isRussian) {
        int index = function.getParameters().indexOf((Object)literal);
        if (index == -1) {
            return null;
        }
        String name = function.getName().getFullContent();
        String parameterValue = DcsExprUtils.getStringLiteralValue(literal);
        if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_FunctionBeginOfPeriod) || this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_FunctionEndOfPeriod)) {
            if (index == 1) {
                return this.getFunctionParameterEnumValue(parameterValue, ExpressionsFunctionsProvider.BEGIN_PERIOD_TYPES_RU, ExpressionsFunctionsProvider.BEGIN_PERIOD_TYPES_EN, isRussian, false);
            }
        } else if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_FunctionDateAdd)) {
            if (index == 1) {
                return this.getFunctionParameterEnumValue(parameterValue, ExpressionsFunctionsProvider.ADD_PERIOD_TYPES_RU, ExpressionsFunctionsProvider.ADD_PERIOD_TYPES_EN, isRussian, false);
            }
        } else if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_FunctionDateDiff)) {
            if (index == 2) {
                return this.getFunctionParameterEnumValue(parameterValue, ExpressionsFunctionsProvider.DIFF_PERIOD_TYPES_RU, ExpressionsFunctionsProvider.DIFF_PERIOD_TYPES_EN, isRussian, false);
            }
        } else if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_Eval)) {
            if (index == 1) {
                return this.getFunctionParameterEnumValue(parameterValue, ExpressionsFunctionsProvider.EVAL_GROUP_RU, ExpressionsFunctionsProvider.EVAL_GROUP_EN, isRussian, false);
            }
            if (index == 2) {
                return this.getFunctionParameterEnumValue(parameterValue, ExpressionsFunctionsProvider.EVAL_TYPES_RU, ExpressionsFunctionsProvider.EVAL_TYPES_EN, isRussian, false);
            }
        } else if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_EvalExpression)) {
            if (index == 1) {
                return this.getFunctionParameterEnumValue(parameterValue, ExpressionsFunctionsProvider.EVAL_GROUP_RU, ExpressionsFunctionsProvider.EVAL_GROUP_EN, isRussian, false);
            }
            if (index == 2) {
                return this.getFunctionParameterEnumValue(parameterValue, ExpressionsFunctionsProvider.EVAL_EXPRESSION_SCOPE_TYPES_RU, ExpressionsFunctionsProvider.EVAL_EXPRESSION_SCOPE_TYPES_EN, isRussian, false);
            }
            if (index == 3 || index == 4) {
                return this.getFunctionParameterEnumValue(parameterValue, EVAL_EXPRESSION_BEGIN_TYPES_RU, EVAL_EXPRESSION_BEGIN_TYPES_EN, isRussian, true);
            }
            if (index == 5 || index == 6) {
                return this.getFunctionParameterEnumValue(parameterValue, EVAL_EXPRESSION_SORT_RU, EVAL_EXPRESSION_SORT_EN, isRussian, false);
            }
            if (index == 7) {
                return this.getFunctionParameterEnumValue(parameterValue, ExpressionsFunctionsProvider.EVAL_EXPRESSION_SAME_TYPES_RU, ExpressionsFunctionsProvider.EVAL_EXPRESSION_SAME_TYPES_EN, isRussian, false);
            }
        } else if (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_FunctionCast) ? index == 1 : (this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_Type) || this.isStringEqualsTerms(name, ExpressionsTerms.kDCSExprTerm_ValueType)) && index == 0) {
            return this.getFunctionParameterEnumValue(parameterValue, ExpressionsFunctionsProvider.SIMPLE_TYPES_RU, ExpressionsFunctionsProvider.SIMPLE_TYPES_EN, isRussian, true);
        }
        return null;
    }

    private boolean isStringEqualsTerms(String str, String[] terms) {
        return str.equalsIgnoreCase(terms[0]) || str.equalsIgnoreCase(terms[1]);
    }

    private String getFunctionParameterEnumValue(String parameterValue, String[] valuesRu, String[] valuesEn, boolean isRussian, boolean begin) {
        String[] values = isRussian ? valuesEn : valuesRu;
        int index = this.getStringIndex(parameterValue, values, begin);
        if (index == -1) {
            return null;
        }
        if (begin) {
            String value = values[index];
            if (value.equalsIgnoreCase(parameterValue)) {
                return isRussian ? valuesRu[index] : valuesEn[index];
            }
            String newValue = isRussian ? valuesRu[index] : valuesEn[index];
            return parameterValue.replace(value, newValue);
        }
        return isRussian ? valuesRu[index] : valuesEn[index];
    }

    private int getStringIndex(String str, String[] values, boolean begin) {
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            if (begin) {
                if (str.equalsIgnoreCase(value)) {
                    return i;
                }
                if (str.length() >= value.length() + 2 && str.startsWith(value) && str.charAt(value.length()) == '(' && str.charAt(str.length() - 1) == ')') {
                    return i;
                }
            } else if (str.equalsIgnoreCase(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

