/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.expressions.naming;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.dcs.expressions.model.Expression;
import com._1c.g5.v8.dt.dcs.expressions.model.ExpressionWithAlias;
import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com._1c.g5.v8.dt.dcs.expressions.model.ExpressionsPackage;
import com._1c.g5.v8.dt.dcs.expressions.model.Function;
import com._1c.g5.v8.dt.dcs.expressions.model.Ident;
import com._1c.g5.v8.dt.dcs.expressions.model.MultiPartName;
import com._1c.g5.v8.dt.dcs.expressions.model.Name;
import com._1c.g5.v8.dt.dcs.expressions.model.Parameter;
import com._1c.g5.v8.dt.dcs.expressions.model.SinglePartName;
import com._1c.g5.v8.dt.dcs.expressions.model.StringLiteral;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.v8.dt.dcs.expressions.DcsExprUtils;
import com.e1c.langtool.v8.dt.dcs.expressions.StringLiteralInternalizeTokenProvider;
import com.e1c.langtool.v8.dt.dcs.expressions.settings.DcsExprFeatureSettings;
import com.e1c.langtool.v8.dt.internal.dcs.expressions.ExprPlugin;
import com.e1c.langtool.v8.dt.naming.AbstractFeatureKeyComputer;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class DcsExprFeatureKeyComputer
extends AbstractFeatureKeyComputer {
    private static final String EXPRESSIONS_STRING = "Expr";
    private static final String FQN_NSTR = "NStr";
    private static final String FQN_PART = "Part";
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IV8ProjectManager projectManager;
    @Inject
    private StringLiteralInternalizeTokenProvider stringLiteralInternalizeTokenProvider;
    @Inject
    private IDependentModelProvider dependentModelProvider;

    public static DcsExprFeatureKeyComputer create() {
        DcsExprFeatureKeyComputer provider = new DcsExprFeatureKeyComputer();
        ExprPlugin.getDefault().getInjector().injectMembers((Object)provider);
        return provider;
    }

    public boolean isSupported(EObject object) {
        if (object == null) {
            return false;
        }
        EPackage objectPackage = object.eClass().getEPackage();
        return objectPackage.equals(ExpressionsPackage.eINSTANCE);
    }

    public FeatureKey computeFqn(EObject obj) {
        if (obj instanceof Expressions) {
            return this._computeFqn((Expressions)obj);
        }
        if (obj instanceof Parameter) {
            return this._computeFqn((Parameter)obj);
        }
        if (obj instanceof Ident) {
            return this._computeFqn((Ident)obj);
        }
        if (obj instanceof SinglePartName) {
            return this._computeFqn((Name)((SinglePartName)obj));
        }
        if (obj instanceof MultiPartName) {
            return this._computeFqn((Name)((MultiPartName)obj));
        }
        if (obj instanceof ExpressionWithAlias) {
            return this._computeFqn((ExpressionWithAlias)obj);
        }
        if (obj instanceof StringLiteral) {
            return this._computeFqn((StringLiteral)obj);
        }
        if (obj instanceof Expression) {
            return this._computeFqn((Expression)obj);
        }
        ExprPlugin.log(ExprPlugin.createWarningStatus(MessageFormat.format("DCS Expr: Unhandled Feature Key parameter type: {0}", obj)));
        return this.computeListOrParent(obj);
    }

    protected FeatureKey _computeFqn(Expressions obj) {
        String literalText;
        String[] parts;
        EObject parent = this.dependentModelProvider.getParent((EObject)obj);
        EStructuralFeature feature = this.dependentModelProvider.getParentFeature((EObject)obj);
        if (parent == null || feature == null) {
            return SegmentFeatureKey.EMPTY;
        }
        FeatureKey _xifexpression = this.computeExpressionFeatureFQN(parent, feature);
        if (_xifexpression == null) {
            return SegmentFeatureKey.EMPTY;
        }
        if (parent instanceof StringLiteral && feature.equals(DcsExprFeatureSettings.Literals.STRING_LITERAL__VALUE.getEFeature()) && parent.eContainer() instanceof Function && this.stringLiteralInternalizeTokenProvider.isExpressionListLiteral((Function)parent.eContainer(), (StringLiteral)parent) && (parts = (literalText = DcsExprUtils.getStringLiteralValue((StringLiteral)parent)).split(",")).length > 1) {
            _xifexpression = _xifexpression.append(FQN_PART);
            String source = NodeModelUtils.getNode((EObject)obj).getRootNode().getText();
            int i = 0;
            while (i < parts.length) {
                String part = parts[i];
                if (part.equals(source)) {
                    _xifexpression = _xifexpression.append(Integer.toString(i));
                    break;
                }
                ++i;
            }
        }
        return _xifexpression;
    }

    protected FeatureKey computeExpressionFeatureFQN(EObject object, EStructuralFeature feature) {
        FeatureKey featureKey = this.featureKeyProvider.getKey(object);
        if (featureKey == null) {
            return SegmentFeatureKey.EMPTY;
        }
        return featureKey.append(EXPRESSIONS_STRING).append(this.toFeatureKey(StringUtils.capitalize((String)feature.getName())));
    }

    protected FeatureKey _computeFqn(StringLiteral obj) {
        FeatureKey _xifexpression = null;
        if (DcsExprUtils.isNls((EObject)obj)) {
            String languageCode = this.getLanguageCode(obj);
            String literalKey = null;
            Map<String, String> nlsStrings = DcsExprUtils.getNlsLocalStrings((EObject)obj);
            if (Strings.isNullOrEmpty((String)languageCode) && nlsStrings.size() == 1) {
                for (Map.Entry<String, String> entry : nlsStrings.entrySet()) {
                    literalKey = entry.getValue();
                }
            } else if (!Strings.isNullOrEmpty((String)languageCode)) {
                literalKey = nlsStrings.get(languageCode);
            }
            if (!Strings.isNullOrEmpty(literalKey)) {
                Expressions expr = (Expressions)EcoreUtil2.getContainerOfType((EObject)obj, Expressions.class);
                _xifexpression = this.computeFqn((EObject)expr);
                _xifexpression = _xifexpression.append(this.toFeatureKey(FQN_NSTR));
                _xifexpression = _xifexpression.append(literalKey);
            }
        } else if (obj.eContainer() instanceof Function && this.stringLiteralInternalizeTokenProvider.isExpressionLiteral((Function)obj.eContainer(), obj)) {
            EStructuralFeature feature = obj.eContainingFeature();
            EObject parent = obj.eContainer();
            Object value = parent.eGet(feature);
            if (value instanceof EList && (_xifexpression = this._computeFqn((Function)parent)) != null) {
                EList list = (EList)value;
                _xifexpression = _xifexpression.append(StringUtils.capitalize((String)feature.getName()));
                _xifexpression = _xifexpression.append(Integer.toString(list.indexOf((Object)obj)));
            }
        } else {
            String _value = DcsExprUtils.getStringLiteralValue(obj);
            if (StringUtils.isNotEmpty((String)_value)) {
                Expressions expr = (Expressions)EcoreUtil2.getContainerOfType((EObject)obj, Expressions.class);
                _xifexpression = this.computeFqn((EObject)expr);
                _xifexpression = _xifexpression.append(this.toFeatureKey("Str"));
                _xifexpression = _xifexpression.append(this.toFeatureKey(_value));
            }
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(Parameter obj) {
        FeatureKey _xifexpression = null;
        String _value = obj.getValue();
        if (!StringUtils.isNullOrEmpty((String)_value)) {
            Expressions expr = (Expressions)EcoreUtil2.getContainerOfType((EObject)obj, Expressions.class);
            _xifexpression = this.computeFqn((EObject)expr);
            _xifexpression = _xifexpression.append(this.toFeatureKey("Param"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_value));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(Ident obj) {
        FeatureKey _xifexpression = null;
        String _value = obj.getValue();
        if (!StringUtils.isNullOrEmpty((String)_value)) {
            Expressions expr = (Expressions)EcoreUtil2.getContainerOfType((EObject)obj, Expressions.class);
            _xifexpression = this.computeFqn((EObject)expr);
            _xifexpression = _xifexpression.append(this.toFeatureKey("Ident"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_value));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(Name obj) {
        FeatureKey _xifexpression = null;
        String _name = obj.getContent();
        if (!StringUtils.isNullOrEmpty((String)_name)) {
            Expressions expr = (Expressions)EcoreUtil2.getContainerOfType((EObject)obj, Expressions.class);
            _xifexpression = this.computeFqn((EObject)expr);
            _xifexpression = _xifexpression.append(this.toFeatureKey("Name"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_name));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(Function obj) {
        FeatureKey _xifexpression = null;
        String _name = obj.getName().getFullContent();
        if (!StringUtils.isNullOrEmpty((String)_name)) {
            Expressions expr = (Expressions)EcoreUtil2.getContainerOfType((EObject)obj, Expressions.class);
            _xifexpression = this.computeFqn((EObject)expr);
            _xifexpression = _xifexpression.append(this.toFeatureKey("Func"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_name));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(ExpressionWithAlias obj) {
        FeatureKey _xifexpression = null;
        String _alias = obj.getAlias();
        if (!StringUtils.isNullOrEmpty((String)_alias)) {
            Expressions expr = (Expressions)EcoreUtil2.getContainerOfType((EObject)obj, Expressions.class);
            _xifexpression = this.computeFqn((EObject)expr);
            _xifexpression = _xifexpression.append(this.toFeatureKey("Alias"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_alias));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(Expression obj) {
        EObject parent = EcoreUtil2.getContainerOfType((EObject)obj.eContainer(), Expression.class);
        if (parent == null) {
            parent = EcoreUtil2.getContainerOfType((EObject)obj.eContainer(), Expressions.class);
        }
        return this.computeFqn(parent);
    }

    protected String getLanguageCode(StringLiteral literal) {
        Language language;
        IV8Project v8Project = this.projectManager.getProject((EObject)literal);
        if (v8Project != null && (language = v8Project.getDefaultLanguage()) != null) {
            return language.getLanguageCode();
        }
        return null;
    }
}

