/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.bm.integration.IBmTask;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatedProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ProjectTranslationProvider;
import com.e1c.langtool.v8.dt.ui.IFindSourceMdObjectHelper;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FindSourceMdObjectHelper
implements IFindSourceMdObjectHelper {
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IBmModelManager bmModelManager;
    @Inject
    private IFeatureSettingsService featureSettingsService;
    @Inject
    private ITranslatedProjectManager translatedProjectManager;

    @Override
    public MdObject findSourceMdObject(MdObject translatedMdObject) {
        IProject project = this.resourceLookup.getProject((EObject)translatedMdObject);
        if (project == null) {
            return null;
        }
        ITranslatedProject translatedProject = this.translatedProjectManager.getProject(project);
        if (translatedProject == null || translatedProject.getSourceProject() == null) {
            return null;
        }
        IBmModel sourceModel = this.bmModelManager.getModel(translatedProject.getSourceProject().getProject());
        if (sourceModel == null) {
            return null;
        }
        ArrayList<MdObject> path = new ArrayList<MdObject>();
        this.buildPathToRoot(translatedMdObject, path);
        ProjectTranslationProvider translationProvider = ProjectTranslationProvider.create((ITranslatedV8Project)((ITranslatedV8Project)translatedProject));
        return (MdObject)sourceModel.executeReadonlyTask((IBmTask)new FindSourceObjectByPathTask(path, (IProjectTranslationProvider)translationProvider));
    }

    private void buildPathToRoot(MdObject current, List<MdObject> path) {
        if (current == null) {
            return;
        }
        this.buildPathToRoot((MdObject)current.eContainer(), path);
        path.add(current);
    }

    private class FindSourceObjectByPathTask
    extends AbstractBmTask<MdObject> {
        private final List<MdObject> translatedPath;
        private final IProjectTranslationProvider translationProvider;
        private final TranslateLanguage language;

        public FindSourceObjectByPathTask(List<MdObject> translatedPath, IProjectTranslationProvider translationProvider) {
            this.translatedPath = translatedPath;
            this.translationProvider = translationProvider;
            this.language = translationProvider.getProject().getDefaultLanguage();
        }

        public MdObject execute(IBmTransaction transaction, IProgressMonitor monitor) {
            MdObject current = null;
            for (MdObject step : this.translatedPath) {
                if (!(current == null ? (current = this.findTopLevelObject(transaction, step, this.translationProvider)) == null : (current = this.findChildByName(current, step.getName(), step.eClass())) == null)) continue;
                return null;
            }
            return current;
        }

        private MdObject findTopLevelObject(IBmTransaction transaction, MdObject translatedObject, IProjectTranslationProvider provider) {
            String translatedName = translatedObject.getName();
            Iterator it = transaction.getTopObjectIterator(translatedObject.eClass());
            while (it.hasNext()) {
                IBmObject sourceObject = (IBmObject)it.next();
                Assert.isTrue((boolean)(sourceObject instanceof MdObject));
                MdObject sourceMdObject = (MdObject)sourceObject;
                EFeatureSettings featureSettings = FindSourceMdObjectHelper.this.featureSettingsService.getSettings((EStructuralFeature)MdClassPackage.Literals.MD_OBJECT__NAME, (EObject)sourceMdObject);
                String translation = provider.getTranslation((EObject)sourceMdObject, featureSettings, this.language);
                if (!(translation != null ? translatedName.equals(translation) : translatedName.equals(sourceMdObject.getName()))) continue;
                return sourceMdObject;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private MdObject findChildByName(MdObject parent, String translatedName, EClass targetEClass) {
            for (EObject sourceChild : parent.eContents()) {
                EFeatureSettings featureSettings;
                void mdChild;
                String translation;
                EObject eObject = sourceChild;
                if (!(eObject instanceof MdObject)) continue;
                MdObject cfr_ignored_0 = (MdObject)eObject;
                MdObject cfr_ignored_1 = (MdObject)eObject;
                if (sourceChild.eClass() != targetEClass || !((translation = this.translationProvider.getTranslation((EObject)mdChild, featureSettings = FindSourceMdObjectHelper.this.featureSettingsService.getSettings((EStructuralFeature)MdClassPackage.Literals.MD_OBJECT__NAME, (EObject)mdChild), this.language)) != null ? translatedName.equals(translation) : translatedName.equals(mdChild.getName()))) continue;
                return mdChild;
            }
            return null;
        }
    }
}

