/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatedProjectManager;
import com.google.inject.Inject;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;

public class ProjectTypePropertyTester
extends PropertyTester {
    private static final String IS_TRANSLATED_PROJECT = "isTranslatedProject";
    private static final String IS_V8_PROJECT = "isV8Project";
    @Inject
    private ITranslatedProjectManager translatedProjectManager;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IResourceLookup resourceLookup;

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IProject project;
        if (IS_TRANSLATED_PROJECT.equals(property) && (project = this.getContextProject(receiver)) != null) {
            ITranslatedProject translatedProject = this.translatedProjectManager.getProject(project);
            return translatedProject != null && translatedProject.getSourceProject() != null;
        }
        if (IS_V8_PROJECT.equals(property)) {
            project = this.getContextProject(receiver);
            IV8Project iV8Project = this.v8ProjectManager.getProject(project);
            return iV8Project != null;
        }
        return false;
    }

    private IProject getContextProject(Object object) {
        if (object instanceof IProject) {
            return (IProject)object;
        }
        if (object instanceof IResource) {
            return ((IResource)object).getProject();
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            if (adaptable.getAdapter(IProject.class) != null) {
                return (IProject)adaptable.getAdapter(IProject.class);
            }
            if (adaptable.getAdapter(IResource.class) != null) {
                return ((IResource)adaptable.getAdapter(IResource.class)).getProject();
            }
            if (adaptable.getAdapter(EObject.class) != null) {
                return this.resourceLookup.getProject((EObject)adaptable.getAdapter(EObject.class));
            }
        } else if (object instanceof EObject) {
            return this.resourceLookup.getProject((EObject)object);
        }
        return null;
    }
}

