/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.commands;

import com._1c.g5.v8.dt.common.ui.WorkbenchUtils;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.ui.util.ContentUtil;
import com._1c.g5.v8.dt.ui.util.OpenHelper;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.internal.ui.commands.Messages;
import com.e1c.langtool.v8.dt.ui.IFindSourceMdObjectHelper;
import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenSourceMdObjectHandler
extends AbstractHandler {
    @Inject
    private IFindSourceMdObjectHelper findSourceObjectHelper;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MdObject translatedMdObject = this.getSelectedMdObject(event);
        if (translatedMdObject == null) {
            return null;
        }
        MdObject sourceObject = this.findSourceObjectHelper.findSourceMdObject(translatedMdObject);
        if (sourceObject != null) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            this.openModelObject(window, shell, (EObject)sourceObject);
        } else {
            V8UiPlugin.logInfo(Messages.OpenSourceMdObjectHandler_Source_object_not_found);
        }
        return null;
    }

    private MdObject getSelectedMdObject(ExecutionEvent event) {
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof MdObject) {
            return (MdObject)element;
        }
        return null;
    }

    private void openModelObject(IWorkbenchWindow window, Shell shell, EObject modelObject) {
        Display display = shell.getDisplay();
        display.asyncExec(() -> {
            if (!display.isDisposed()) {
                new OpenHelper(window.getActivePage()).openEditor(modelObject);
                WorkbenchUtils.selectAndReveal((Object)ContentUtil.getActualObject((EObject)modelObject), (IWorkbenchWindow)window);
            }
        });
    }
}

