/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.generatestring;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.v8.dt.internal.ui.generatestring.V8ProjectGenerateTranslationStringsWizard;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class V8ProjectGenerateTranslationStringsHandler
extends AbstractHandler {
    @Inject
    private Provider<V8ProjectGenerateTranslationStringsWizard> generateTranslationStringsWizardProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        Map<IProject, Collection<TranslationSource>> projectSelection = this.getSelectedObjects(selection);
        for (IProject project : projectSelection.keySet()) {
            if (project == null) continue;
            V8ProjectGenerateTranslationStringsWizard wizard = this.getGenerateTranslationStringsWizard();
            wizard.init(project, projectSelection.get(project));
            WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (IWizard)wizard);
            dialog.open();
            break;
        }
        return null;
    }

    private Map<IProject, Collection<TranslationSource>> getSelectedObjects(ISelection selection) {
        HashMap<IProject, Collection<TranslationSource>> projectSelection = new HashMap<IProject, Collection<TranslationSource>>();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            for (Object element : strucSelection) {
                if (element instanceof IProject) {
                    Collection elements = (Collection)projectSelection.get(element);
                    if (elements != null) continue;
                    projectSelection.put((IProject)element, new ArrayList());
                    continue;
                }
                TranslationSource source = TranslationUtils.getTranslationSource(element);
                if (source == null || source.getProject() == null) continue;
                ArrayList<TranslationSource> elements = (ArrayList<TranslationSource>)projectSelection.get(source.getProject());
                if (elements == null) {
                    elements = new ArrayList<TranslationSource>();
                }
                elements.add(source);
                projectSelection.put(source.getProject(), elements);
            }
        }
        return projectSelection;
    }

    private V8ProjectGenerateTranslationStringsWizard getGenerateTranslationStringsWizard() {
        return (V8ProjectGenerateTranslationStringsWizard)((Object)this.generateTranslationStringsWizardProvider.get());
    }
}

