/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.preferences;

import com._1c.g5.v8.dt.common.databinding.BindingSupport;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.internal.ui.preferences.Messages;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.text.StringToNumberConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.databinding.dialog.DialogPageSupport;
import org.eclipse.jface.databinding.dialog.IValidationMessageProvider;
import org.eclipse.jface.databinding.dialog.ValidationMessageProvider;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class V8TranslationPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final String EMPTY_LANGUAGE = "";
    @Inject
    private ITranslatingProjectManager projectManager;
    @Inject
    private TranslationPreferences preferences;
    private Button fillEmptyButton;
    private Button fillEmptyHtmlButton;
    private Button fillEmptyHelpButton;
    private Button contextDefStorageCheckBackTranslation;
    private Button enablePersistentKeyMappingCache;
    private TableViewer fillupLanguageViewer;
    IObservableValue<Integer> maxItemsInPreviewListObservableValue;
    private final BindingSupport bindingSupport = new BindingSupport();
    private DataBindingContext dataBindingContext;
    private Map<String, TranslateLanguage> langauges = new LinkedHashMap<String, TranslateLanguage>();
    private Map<String, String> fillupLanguages = Maps.newHashMap();

    public boolean performOk() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setDefault("com.e1c.langtool.v8.dt.ui.maxItemsInPreviewList", 1000);
        preferenceStore.setValue("com.e1c.langtool.v8.dt.ui.maxItemsInPreviewList", ((Integer)this.maxItemsInPreviewListObservableValue.getValue()).intValue());
        if (this.changeDetected()) {
            boolean needBuild = this.askForBuild();
            this.saveSettings();
            if (needBuild) {
                this.build();
            }
        }
        return true;
    }

    public void dispose() {
        this.bindingSupport.dispose();
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.dataBindingContext = this.bindingSupport.getDBContext();
        DialogPageSupport.create((DialogPage)this, (DataBindingContext)this.dataBindingContext).setValidationMessageProvider((IValidationMessageProvider)new ValidationMessageProvider(){

            public int getMessageType(ValidationStatusProvider statusProvider) {
                int type = super.getMessageType(statusProvider);
                V8TranslationPropertyPage.this.setValid(type != 3);
                return type;
            }
        });
        this.addTranslationSection(composite);
        this.addSeparator(composite);
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return V8UiPlugin.getDefault().getPreferenceStore(this.getCurrentProject());
    }

    protected void performDefaults() {
        TranslationProperties prop = this.preferences.getTranslationProperties(this.getCurrentProject());
        this.fillEmptyButton.setSelection(prop.fillEmptyInterfaceTranslationFromSource());
        this.fillEmptyHelpButton.setSelection(prop.fillEmptyHelpTranslationFromSource());
        this.fillEmptyHtmlButton.setSelection(prop.fillEmptyHtmlTranslationFromSource());
        this.contextDefStorageCheckBackTranslation.setSelection(prop.isContextDefStorageCheckBackTranslation());
        this.enablePersistentKeyMappingCache.setSelection(prop.isEnablePersistentKeyMappingCache());
        this.loadFillupLanguages(prop);
        this.fillupLanguageViewer.refresh();
        this.maxItemsInPreviewListObservableValue.setValue((Object)1000);
        super.performDefaults();
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addTranslationSection(Composite parent) {
        Font font = parent.getFont();
        Composite composite = this.createDefaultComposite(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        composite.setLayoutData((Object)new GridData(1808));
        Composite buttonComposite = this.createDefaultComposite(composite);
        TranslationProperties prop = this.preferences.getTranslationProperties(this.getCurrentProject());
        this.fillEmptyButton = this.createButton(buttonComposite, Messages.V8TranslationPropertyPage_Fill_empty_interface_translation_from_source_language, "fillEmptyInterfaceTranslationFromSource", prop.fillEmptyInterfaceTranslationFromSource());
        this.fillEmptyHtmlButton = this.createButton(buttonComposite, Messages.V8TranslationPropertyPage_Fill_empty_html_translation_from_source_language, "fillEmptyHtmlTranslationFromSource", prop.fillEmptyHtmlTranslationFromSource());
        this.fillEmptyHelpButton = this.createButton(buttonComposite, Messages.V8TranslationPropertyPage_Fill_empty_help_translation_from_source_language, "fillEmptyHelpTranslationFromSource", prop.fillEmptyHelpTranslationFromSource());
        this.contextDefStorageCheckBackTranslation = this.createButton(buttonComposite, Messages.V8TranslationPropertyPage_Platform_Context_Definition_storage_check_back_translatios_and_provides_only_unique, "contextDefStorageCheckBackTranslation", prop.isContextDefStorageCheckBackTranslation());
        this.enablePersistentKeyMappingCache = this.createButton(buttonComposite, Messages.V8TranslationPropertyPage_Enable_persistent_cache_of_mapping_keys_used_for_converting_language_projects, "enablePersistentKeyMappingCache", prop.isEnablePersistentKeyMappingCache());
        this.createMaxItemsTextField(composite, Messages.V8TranslationPropertyPage_Max_items_in_preview_list, String.valueOf(this.getMaxItemsInList()));
        Composite tableComposite = this.createDefaultComposite(composite);
        ((GridLayout)tableComposite.getLayout()).numColumns = 1;
        tableComposite.setLayoutData((Object)new GridData(1808));
        this.fillupLanguageViewer = new TableViewer(tableComposite, 68352);
        Table table = this.fillupLanguageViewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewerColumn column = new TableViewerColumn(this.fillupLanguageViewer, 0);
        column.getColumn().setText(Messages.V8TranslationPropertyPage_Language);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 150));
        column.getColumn().setResizable(false);
        column.getColumn().setMoveable(true);
        TableViewerColumn column2 = new TableViewerColumn(this.fillupLanguageViewer, 0);
        column2.getColumn().setText(Messages.V8TranslationPropertyPage_Fill_up_from);
        tableColumnLayout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 150));
        column2.getColumn().setMoveable(true);
        this.fillupLanguageViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fillupLanguageViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.loadFillupLanguages(prop);
        ArrayList<TranslateLanguage> items = new ArrayList<TranslateLanguage>();
        items.add(new TranslateLanguage(){

            public UUID getUuid() {
                return null;
            }

            public String getPresentation() {
                return this.getName();
            }

            public TranslationOption getOption() {
                return TranslationOption.INTERFACE_ONLY;
            }

            public String getName() {
                return V8TranslationPropertyPage.EMPTY_LANGUAGE;
            }

            public String getLanguageCode() {
                return V8TranslationPropertyPage.EMPTY_LANGUAGE;
            }
        });
        items.addAll(this.langauges.values());
        column2.setEditingSupport((EditingSupport)new InlineEditingSupport((ColumnViewer)this.fillupLanguageViewer, items));
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Button createButton(Composite parent, String label, String key, boolean isCheck) {
        final Button but = new Button(parent, 32);
        but.setData((Object)key);
        but.setSelection(isCheck);
        but.pack();
        Label buttonLabel = new Label(parent, 0);
        buttonLabel.setText(label);
        buttonLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                but.setSelection(!but.getSelection());
            }
        });
        buttonLabel.pack();
        return but;
    }

    private void createMaxItemsTextField(Composite parent, String labelText, String fieldText) {
        Composite textComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(textComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textComposite);
        Label beforeLabel = new Label(textComposite, 0);
        beforeLabel.setText(labelText);
        Text textField = new Text(textComposite, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        textField.setLayoutData((Object)gd);
        textField.setText(fieldText);
        this.maxItemsInPreviewListObservableValue = WritableValue.withValueType(Integer.class);
        this.maxItemsInPreviewListObservableValue.setValue((Object)Integer.parseInt(fieldText));
        UpdateValueStrategy targetToModel = new UpdateValueStrategy();
        targetToModel.setAfterGetValidator(value -> {
            String strValue = value;
            if (strValue == null || strValue.trim().isEmpty()) {
                return ValidationStatus.error((String)Messages.V8TranslationPropertyPage_Max_items_field_cannot_be_empty);
            }
            try {
                int val = Integer.parseInt(strValue);
                if (val <= 0) {
                    return ValidationStatus.error((String)Messages.V8TranslationPropertyPage_Max_items_is_incorrect);
                }
            }
            catch (NumberFormatException e) {
                return ValidationStatus.error((String)Messages.V8TranslationPropertyPage_Max_items_is_incorrect);
            }
            return ValidationStatus.ok();
        });
        targetToModel.setConverter((IConverter)StringToNumberConverter.toInteger((Format)NumberFormat.getIntegerInstance(Locale.ROOT), (boolean)true));
        UpdateValueStrategy modelToTarget = UpdateValueStrategy.create((IConverter)new Converter(Integer.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject instanceof Integer) {
                    return String.valueOf(fromObject);
                }
                return "0";
            }
        });
        this.dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)textField), this.maxItemsInPreviewListObservableValue, targetToModel, modelToTarget);
    }

    private void loadFillupLanguages(TranslationProperties prop) {
        this.langauges.clear();
        this.fillupLanguages.clear();
        ITranslatingProject translatingProject = this.projectManager.getProject(this.getCurrentProject());
        translatingProject.getInterfaceLanguages().forEach(l -> this.langauges.put(l.getLanguageCode(), (TranslateLanguage)l));
        translatingProject.getInterfaceLanguages().forEach(l -> {
            String fillupFrom = prop.getLanguageToFillEmptyInterfaceTranslation(l.getLanguageCode());
            if (fillupFrom == null) {
                String languageName = prop.getLanguageToFillEmptyInterfaceTranslation(l.getName());
                fillupFrom = this.langauges.values().stream().filter(e -> languageName != null && languageName.equals(e.getName())).findAny().map(TranslateLanguage::getLanguageCode).orElse(EMPTY_LANGUAGE);
            }
            this.fillupLanguages.put(l.getLanguageCode(), fillupFrom == null ? EMPTY_LANGUAGE : fillupFrom);
        });
        this.fillupLanguageViewer.setInput(this.langauges.values());
    }

    private boolean changeDetected() {
        TranslationProperties prop = this.preferences.getTranslationProperties(this.getCurrentProject());
        if (prop.fillEmptyInterfaceTranslationFromSource() != this.fillEmptyButton.getSelection() || prop.fillEmptyHelpTranslationFromSource() != this.fillEmptyHelpButton.getSelection() || prop.fillEmptyHtmlTranslationFromSource() != this.fillEmptyHtmlButton.getSelection() || prop.isContextDefStorageCheckBackTranslation() != this.contextDefStorageCheckBackTranslation.getSelection() || prop.isEnablePersistentKeyMappingCache() != this.enablePersistentKeyMappingCache.getSelection()) {
            return true;
        }
        HashMap source = new HashMap();
        ITranslatingProject translatingProject = this.projectManager.getProject(this.getCurrentProject());
        translatingProject.getInterfaceLanguages().forEach(l -> {
            String fillupFrom = prop.getLanguageToFillEmptyInterfaceTranslation(l.getLanguageCode());
            if (fillupFrom == null) {
                String languageName = prop.getLanguageToFillEmptyInterfaceTranslation(l.getName());
                fillupFrom = this.langauges.values().stream().filter(e -> languageName != null && languageName.equals(e.getName())).findAny().map(TranslateLanguage::getLanguageCode).orElse(EMPTY_LANGUAGE);
            }
            source.put(l.getLanguageCode(), fillupFrom == null ? EMPTY_LANGUAGE : fillupFrom);
        });
        return !this.fillupLanguages.equals(source);
    }

    private void saveSettings() {
        TranslationProperties prop = this.preferences.getTranslationProperties(this.getCurrentProject());
        prop.setFillEmptyInterfaceTranslationFromSource(this.fillEmptyButton.getSelection());
        prop.setFillEmptyHelpTranslationFromSource(this.fillEmptyHelpButton.getSelection());
        prop.setFillEmptyHtmlTranslationFromSource(this.fillEmptyHtmlButton.getSelection());
        prop.setContextDefStorageCheckBackTranslation(this.contextDefStorageCheckBackTranslation.getSelection());
        prop.setEnablePersistentKeyMappingCache(this.enablePersistentKeyMappingCache.getSelection());
        prop.setLanguageToFillEmptyInterfaceTranslation(this.fillupLanguages);
    }

    private IProject getCurrentProject() {
        return ((IResource)this.getElement().getAdapter(IResource.class)).getProject();
    }

    private boolean askForBuild() {
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.V8TranslationPropertyPage_BuildSettingsChanged, null, Messages.V8TranslationPropertyPage_BuildSettingsChangedExtended, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
        return dialog.open() == 0;
    }

    private void build() {
        IProject project = this.getCurrentProject();
        try {
            ResourcesPlugin.getWorkspace().run(monitor -> project.build(15, monitor), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            V8UiPlugin.logError(e);
        }
    }

    private int getMaxItemsInList() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        int result = preferenceStore.getInt("com.e1c.langtool.v8.dt.ui.maxItemsInPreviewList");
        return result > 0 ? result : 1000;
    }

    private final class InlineEditingSupport
    extends EditingSupport {
        private ComboBoxViewerCellEditor cellEditor;

        public InlineEditingSupport(ColumnViewer viewer, Collection<TranslateLanguage> items) {
            super(viewer);
            this.cellEditor = new ComboBoxViewerCellEditor((Composite)viewer.getControl());
            this.cellEditor.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            this.cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.cellEditor.setInput(items);
            Control editorControl = this.cellEditor.getControl();
            if (editorControl instanceof CCombo) {
                CCombo comboBox = (CCombo)editorControl;
                comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (InlineEditingSupport.this.cellEditor.getValidator() != null) {
                            V8TranslationPropertyPage.this.setErrorMessage(InlineEditingSupport.this.cellEditor.getValidator().isValid(InlineEditingSupport.this.cellEditor.getViewer().getStructuredSelection().getFirstElement()));
                        }
                    }
                });
            }
        }

        protected CellEditor getCellEditor(Object element) {
            this.cellEditor.setValidator(value -> {
                if (element instanceof TranslateLanguage && value instanceof TranslateLanguage && !TranslationProperties.checkCycleRefs(V8TranslationPropertyPage.this.fillupLanguages, (String)((TranslateLanguage)element).getLanguageCode(), (String)((TranslateLanguage)value).getLanguageCode())) {
                    return Messages.V8TranslationPropertyPage_Cannot_make_cycle_refereses_to_fillup_languages;
                }
                return null;
            });
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (element instanceof TranslateLanguage) {
                TranslateLanguage language = (TranslateLanguage)element;
                String item = V8TranslationPropertyPage.this.fillupLanguages.get(language.getLanguageCode());
                return V8TranslationPropertyPage.this.langauges.get(item);
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (this.cellEditor.isValueValid() && element instanceof TranslateLanguage && value instanceof TranslateLanguage) {
                if (StringUtils.isNotEmpty((String)((TranslateLanguage)value).getLanguageCode())) {
                    V8TranslationPropertyPage.this.fillupLanguages.put(((TranslateLanguage)element).getLanguageCode(), ((TranslateLanguage)value).getLanguageCode());
                }
            } else if (element instanceof TranslateLanguage) {
                V8TranslationPropertyPage.this.fillupLanguages.remove(((TranslateLanguage)element).getLanguageCode());
            }
            V8TranslationPropertyPage.this.fillupLanguageViewer.refresh(element);
            V8TranslationPropertyPage.this.setErrorMessage(null);
        }
    }

    private class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof TranslateLanguage)) {
                return null;
            }
            TranslateLanguage language = (TranslateLanguage)element;
            String text = null;
            switch (columnIndex) {
                case 1: {
                    String languageCode = V8TranslationPropertyPage.this.fillupLanguages.get(language.getLanguageCode());
                    text = Optional.ofNullable(V8TranslationPropertyPage.this.langauges.get(languageCode)).map(TranslateLanguage::getName).orElse(null);
                    break;
                }
                default: {
                    text = language.getName();
                }
            }
            return text;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TranslateLanguage) {
                return ((TranslateLanguage)element).getName();
            }
            return null;
        }
    }
}

