/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.refactoring;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.PrefixTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;

public class FeatureValuePairMatcher {
    private FeatureValuePairMatcher() {
    }

    public static Map<FeatureValue, FeatureValue> matchRenamedTopObjectFeatureValues(Set<FeatureValue> first, Set<FeatureValue> second) {
        HashSet<FeatureValue> uniqueFirst = new HashSet<FeatureValue>(first);
        uniqueFirst.removeAll(second);
        HashSet<FeatureValue> uniqueSecond = new HashSet<FeatureValue>(second);
        uniqueSecond.removeAll(first);
        HashMap<FeatureValue, FeatureValue> result = new HashMap<FeatureValue, FeatureValue>();
        if (!uniqueFirst.isEmpty() && !uniqueSecond.isEmpty()) {
            Map<Integer, List<TaggedFeatureValue>> groupedFirst = uniqueFirst.stream().map(FeatureValuePairMatcher::createTaggedFeatureValue).collect(Collectors.groupingBy(TaggedFeatureValue::getTotalSegmentsCount));
            Map<Integer, List<TaggedFeatureValue>> groupedSecond = uniqueSecond.stream().map(FeatureValuePairMatcher::createTaggedFeatureValue).collect(Collectors.groupingBy(TaggedFeatureValue::getTotalSegmentsCount));
            HashSet<Integer> commonLengths = new HashSet<Integer>(groupedFirst.keySet());
            commonLengths.retainAll(groupedSecond.keySet());
            for (Integer length : commonLengths) {
                List<TaggedFeatureValue> firstList = groupedFirst.get(length);
                List<TaggedFeatureValue> secondList = groupedSecond.get(length);
                for (TaggedFeatureValue firstItem : firstList) {
                    TaggedFeatureValue bestSecond = null;
                    int bestSecondLength = Integer.MIN_VALUE;
                    for (TaggedFeatureValue secondItem : secondList) {
                        if (!firstItem.getFeatureKeySegments().equals(secondItem.getFeatureKeySegments())) continue;
                        List<String> secondAlteredSegments = secondItem.getResourceIdSegments();
                        List<int[]> lcs = FeatureValuePairMatcher.lcs(firstItem.getResourceIdSegments(), secondAlteredSegments);
                        if (lcs.size() <= bestSecondLength || !FeatureValuePairMatcher.isSuitable(lcs)) continue;
                        bestSecond = secondItem;
                        bestSecondLength = lcs.size();
                    }
                    if (bestSecond == null) continue;
                    result.put(firstItem.getFeatureValue(), bestSecond.getFeatureValue());
                }
            }
        }
        return result;
    }

    public static Map<FeatureValue, FeatureValue> matchRenamedChildObjectFeatureValues(Set<FeatureValue> first, Set<FeatureValue> second) {
        HashSet<FeatureValue> uniqueFirst = new HashSet<FeatureValue>(first);
        uniqueFirst.removeAll(second);
        HashSet<FeatureValue> uniqueSecond = new HashSet<FeatureValue>(second);
        uniqueSecond.removeAll(first);
        HashMap<FeatureValue, FeatureValue> result = new HashMap<FeatureValue, FeatureValue>();
        if (!uniqueFirst.isEmpty() && !uniqueSecond.isEmpty()) {
            Map<IPath, List<FeatureValue>> firstGroupedByResourceId = uniqueFirst.stream().collect(Collectors.groupingBy(fv -> fv.getContextKey().getResourceId()));
            Map<IPath, List<FeatureValue>> secondGroupedByResourceId = uniqueSecond.stream().collect(Collectors.groupingBy(fv -> fv.getContextKey().getResourceId()));
            HashSet<IPath> commonResourceIds = new HashSet<IPath>(firstGroupedByResourceId.keySet());
            commonResourceIds.retainAll(secondGroupedByResourceId.keySet());
            for (IPath resourceId : commonResourceIds) {
                List<FeatureValue> firstFeatureValueList = firstGroupedByResourceId.get(resourceId);
                List<FeatureValue> secondFeatureValueList = secondGroupedByResourceId.get(resourceId);
                if (firstFeatureValueList.isEmpty() || secondFeatureValueList.isEmpty()) continue;
                Map<List<String>, FeatureValue> firstPrefixMapping = FeatureValuePairMatcher.calculateMappingByPrefix(firstFeatureValueList);
                Map<List<String>, FeatureValue> secondPrefixMapping = FeatureValuePairMatcher.calculateMappingByPrefix(secondFeatureValueList);
                Map<Integer, List<TaggedFeatureValue>> groupedFirst = firstPrefixMapping.entrySet().stream().map(entry -> new TaggedFeatureValue(FeatureValuePairMatcher.getResourceIdSegments((FeatureValue)entry.getValue()), (List)entry.getKey(), (FeatureValue)entry.getValue())).collect(Collectors.groupingBy(TaggedFeatureValue::getTotalSegmentsCount));
                Map<Integer, List<TaggedFeatureValue>> groupedSecond = secondPrefixMapping.entrySet().stream().map(entry -> new TaggedFeatureValue(FeatureValuePairMatcher.getResourceIdSegments((FeatureValue)entry.getValue()), (List)entry.getKey(), (FeatureValue)entry.getValue())).collect(Collectors.groupingBy(TaggedFeatureValue::getTotalSegmentsCount));
                HashSet<Integer> commonLengths = new HashSet<Integer>(groupedFirst.keySet());
                commonLengths.retainAll(groupedSecond.keySet());
                for (Integer length : commonLengths) {
                    List<TaggedFeatureValue> firstList = groupedFirst.get(length);
                    List<TaggedFeatureValue> secondList = groupedSecond.get(length);
                    for (TaggedFeatureValue firstItem : firstList) {
                        List<String> firstAlteredSegments = firstItem.getFeatureKeySegments();
                        TaggedFeatureValue bestSecond = null;
                        int bestSecondLength = Integer.MIN_VALUE;
                        for (TaggedFeatureValue secondItem : secondList) {
                            List<String> secondAlteredSegments = secondItem.getFeatureKeySegments();
                            List<int[]> lcs = FeatureValuePairMatcher.lcs(firstAlteredSegments, secondAlteredSegments);
                            if (lcs.size() <= bestSecondLength || !FeatureValuePairMatcher.isSuitable(lcs)) continue;
                            bestSecond = secondItem;
                            bestSecondLength = lcs.size();
                        }
                        if (bestSecond == null) continue;
                        result.put(firstItem.getFeatureValue(), bestSecond.getFeatureValue());
                    }
                }
            }
        }
        return result;
    }

    private static Map<List<String>, FeatureValue> calculateMappingByPrefix(List<FeatureValue> list) {
        PrefixTree<FeatureValue> prefixTree = PrefixTree.createPrefixTree();
        for (FeatureValue item : list) {
            prefixTree.insert(item.getContextKey().getFeatureKey().toString(), item);
        }
        return prefixTree.toSegmentedKeyMap(FeatureValuePairMatcher::isSegmentSeparatorCharacter);
    }

    private static boolean isSegmentSeparatorCharacter(Character ch) {
        return ch.charValue() == '.';
    }

    private static TaggedFeatureValue createTaggedFeatureValue(FeatureValue featureValue) {
        return new TaggedFeatureValue(FeatureValuePairMatcher.getResourceIdSegments(featureValue), FeatureValuePairMatcher.getFeatureKeySegments(featureValue), featureValue);
    }

    private static List<String> getResourceIdSegments(FeatureValue featureValue) {
        return Arrays.asList(featureValue.getContextKey().getResourceId().segments());
    }

    private static List<String> getFeatureKeySegments(FeatureValue featureValue) {
        return featureValue.getContextKey().getFeatureKey().getSegments();
    }

    private static boolean isSuitable(List<int[]> lcs) {
        if (lcs.isEmpty()) {
            return false;
        }
        for (int[] pair : lcs) {
            if (pair[0] == pair[1]) continue;
            return false;
        }
        return true;
    }

    private static List<int[]> lcs(List<String> first, List<String> second) {
        int j;
        int firstLen = first.size();
        int secondLen = second.size();
        ArrayList<int[]> lcs = new ArrayList<int[]>();
        int[][] opt = new int[firstLen + 1][secondLen + 1];
        int i = firstLen - 1;
        while (i >= 0) {
            j = secondLen - 1;
            while (j >= 0) {
                opt[i][j] = first.get(i).equals(second.get(j)) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
                --j;
            }
            --i;
        }
        i = 0;
        j = 0;
        while (i < firstLen && j < secondLen) {
            if (first.get(i).equals(second.get(j))) {
                lcs.add(new int[]{i++, j++});
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                ++i;
                continue;
            }
            ++j;
        }
        return lcs;
    }

    private static class TaggedFeatureValue {
        private final List<String> resourceIdSegments;
        private final List<String> featureKeySegments;
        private final FeatureValue featureValue;

        public TaggedFeatureValue(List<String> resourceIdSegments, List<String> featureKeySegments, FeatureValue featureValue) {
            this.resourceIdSegments = resourceIdSegments;
            this.featureKeySegments = featureKeySegments;
            this.featureValue = featureValue;
        }

        public List<String> getResourceIdSegments() {
            return this.resourceIdSegments;
        }

        public List<String> getFeatureKeySegments() {
            return this.featureKeySegments;
        }

        public int getTotalSegmentsCount() {
            return this.resourceIdSegments.size() + this.featureKeySegments.size();
        }

        public FeatureValue getFeatureValue() {
            return this.featureValue;
        }

        public int hashCode() {
            return Objects.hash(this.resourceIdSegments, this.featureKeySegments);
        }

        public boolean equals(Object other) {
            if (!(other instanceof TaggedFeatureValue)) {
                return false;
            }
            return Objects.equals(this.resourceIdSegments, ((TaggedFeatureValue)other).resourceIdSegments) && Objects.equals(this.featureKeySegments, ((TaggedFeatureValue)other).featureKeySegments);
        }
    }
}

