/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PrefixTree<T> {
    private T value;
    private final NavigableMap<Character, PrefixTree<T>> children = new TreeMap<Character, PrefixTree<T>>();

    public static <T> @NonNull PrefixTree<T> createPrefixTree() {
        return new PrefixTree<T>();
    }

    private PrefixTree() {
    }

    public @Nullable T getValue() {
        return this.value;
    }

    public @Nullable T setValue(@Nullable T value) {
        T oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    public @Nullable T insert(@NonNull String key, @NonNull T value) {
        PrefixTree subtree = this;
        int i = 0;
        while (i < key.length()) {
            subtree = subtree.children.computeIfAbsent(Character.valueOf(key.charAt(i)), unusedCh -> new PrefixTree());
            ++i;
        }
        return subtree.setValue(value);
    }

    public @Nullable T find(@NonNull String key) {
        PrefixTree subtree = this;
        int i = 0;
        while (i < key.length()) {
            subtree = (PrefixTree)this.children.get(Character.valueOf(key.charAt(i)));
            if (subtree == null) {
                return null;
            }
            ++i;
        }
        return subtree.getValue();
    }

    public @NonNull Map<List<String>, T> toSegmentedKeyMap(@NonNull Predicate<Character> splitter) {
        HashMap result = new HashMap();
        this.collectSegmentedKeyMap(result, this, splitter, new ArrayList<String>(), new StringBuilder());
        return result;
    }

    private void collectSegmentedKeyMap(Map<List<String>, T> result, PrefixTree<T> tree, Predicate<Character> splitter, List<String> segments, StringBuilder currentSegment) {
        List<String> actualSegments;
        PrefixTree<T> subtree = tree;
        while (subtree.children.size() == 1) {
            Map.Entry<Character, PrefixTree<T>> firstChild = subtree.children.firstEntry();
            currentSegment.append(firstChild.getKey());
            subtree = firstChild.getValue();
            if (subtree.getValue() != null || splitter.test(firstChild.getKey())) break;
        }
        if (currentSegment.length() > 0) {
            actualSegments = new ArrayList<String>(segments);
            actualSegments.add(currentSegment.toString());
        } else {
            actualSegments = segments;
        }
        T subtreeValue = subtree.getValue();
        if (subtreeValue != null) {
            result.put(actualSegments, subtreeValue);
        }
        for (Map.Entry childEntry : subtree.children.entrySet()) {
            this.collectSegmentedKeyMap(result, (PrefixTree)childEntry.getValue(), splitter, actualSegments, new StringBuilder(((Character)childEntry.getKey()).charValue()));
        }
    }
}

