/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.refactoring;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.md.IExternalPropertyManagerRegistry;
import com._1c.g5.v8.dt.metadata.IExternalPropertyManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.refactoring.core.IRenameRefactoringContributor;
import com._1c.g5.v8.dt.refactoring.core.RefactoringOperationDescriptor;
import com._1c.g5.v8.dt.refactoring.core.RefactoringSettings;
import com._1c.g5.v8.dt.refactoring.core.RefactoringStatus;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.ObjectChangeSharedState;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.ObjectPostChange;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.ObjectPreChange;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.Util;
import com.e1c.langtool.v8.dt.sync.EmfObjectProvider;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.Change;

public class RenameRefactoringContributor
implements IRenameRefactoringContributor {
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IProjectFileSystemSupportProvider fileSystemSupportProvider;
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IExternalPropertyManagerRegistry externalPropertyManagerRegistry;
    @Inject
    private EmfObjectProvider emfObjectProvider;
    private ObjectPostChange postChange;

    public Collection<Change> createNativePreChanges(EObject object, String newName, RefactoringSettings settings, RefactoringStatus status) {
        ITranslatingProject translatingProject;
        IProject project = this.resourceLookup.getProject(object);
        if (!Util.isCalledFromComparisonManager() && Util.isTranslationRefactoringEnabled(project) && (translatingProject = this.translatingProjectManager.getProject(project)).isTranslating()) {
            List interfaceLanguages = translatingProject.getInterfaceLanguages();
            List<ITranslationStorageProvider.Storage> storages = Util.getProjectStorages(project, this.storageSettingsManager, this.storageManager);
            if (!storages.isEmpty()) {
                EObject resolvedObject;
                IProjectFileSystemSupport fileSystemSupport = this.fileSystemSupportProvider.getProjectFileSystemSupport(project);
                if (object.eIsProxy()) {
                    Configuration configuration = this.configurationProvider.getConfiguration(object);
                    resolvedObject = EcoreUtil.resolve((EObject)object, (EObject)configuration);
                } else {
                    resolvedObject = object;
                }
                boolean isTopObject = this.isTopLevelObject(resolvedObject);
                EObject objectToProcess = isTopObject ? resolvedObject : this.getTopObject(resolvedObject);
                if (objectToProcess != null) {
                    IBmModel bmModel = this.modelManager.getModel(project);
                    IExternalPropertyManager externalPropertyManager = this.externalPropertyManagerRegistry.getExternalPropertyManager(bmModel);
                    IBmObject owner = (IBmObject)externalPropertyManager.getOwner(object, IBmObject.class);
                    EReference reference = externalPropertyManager.getReference(object);
                    ObjectChangeSharedState sharedState = new ObjectChangeSharedState(objectToProcess, isTopObject, owner, reference, interfaceLanguages, storages, this.collectingService, fileSystemSupport, this.emfObjectProvider);
                    ObjectPreChange preChange = new ObjectPreChange(sharedState);
                    this.postChange = new ObjectPostChange(sharedState);
                    return Collections.singleton(preChange);
                }
            }
        }
        return null;
    }

    public Collection<Change> createNativePostChanges(EObject object, String newName, RefactoringSettings settings, RefactoringStatus status) {
        ObjectPostChange localPostChange = this.postChange;
        this.postChange = null;
        if (localPostChange != null) {
            return Collections.singleton(localPostChange);
        }
        return null;
    }

    public RefactoringOperationDescriptor createPreReferenceUpdateParticipatingOperation(IBmObject object, RefactoringSettings settings, RefactoringStatus status) {
        return null;
    }

    public RefactoringOperationDescriptor createParticipatingOperation(EObject object, RefactoringSettings settings, RefactoringStatus status) {
        return null;
    }

    private boolean isTopLevelObject(EObject object) {
        return object instanceof IBmObject && ((IBmObject)object).bmIsTop();
    }

    private EObject getTopObject(EObject object) {
        EList contents;
        Resource resource;
        if (object != null && (resource = object.eResource()) != null && (contents = resource.getContents()) != null && !contents.isEmpty()) {
            return (EObject)contents.get(0);
        }
        return null;
    }
}

