/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.refactoring;

import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.Util;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.XtextChangeSharedState;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public abstract class XtextChangeBase
extends Change {
    protected final XtextChangeSharedState sharedState;

    public XtextChangeBase(XtextChangeSharedState sharedState) {
        this.sharedState = sharedState;
    }

    protected Set<FeatureValue> collectFeatureValues(final IProgressMonitor monitor) {
        XtextEditor xtextEditor = this.sharedState.getXtextEditor();
        if (xtextEditor != null) {
            return (Set)xtextEditor.getDocument().readOnly((IUnitOfWork)new CancelableUnitOfWork<Set<FeatureValue>, XtextResource>(){

                public Set<FeatureValue> exec(XtextResource resource, final CancelIndicator cancelIndicator) throws Exception {
                    if (cancelIndicator.isCanceled()) {
                        monitor.setCanceled(true);
                        return Collections.emptySet();
                    }
                    EObject documentObject = (EObject)resource.getContents().get(0);
                    if (documentObject != null) {
                        Set<FeatureValue> result = Util.collectFeatureValues(documentObject, XtextChangeBase.this.getCollectingService(), XtextChangeBase.this.getCollectingParameters(), (IProgressMonitor)new NullProgressMonitor(){

                            public boolean isCanceled() {
                                return cancelIndicator.isCanceled() || monitor.isCanceled();
                            }
                        });
                        if (cancelIndicator.isCanceled()) {
                            monitor.setCanceled(true);
                            return Collections.emptySet();
                        }
                        return result;
                    }
                    return Collections.emptySet();
                }
            });
        }
        return Collections.emptySet();
    }

    public IFeatureValueCollectingService getCollectingService() {
        return this.sharedState.getCollectingService();
    }

    private ICollectingParameters getCollectingParameters() {
        return CollectingParameters.builder().collectModel().collectInterface().collectComputedStrings().enableCache().build();
    }
}

