/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.selection;

import com._1c.g5.v8.dt.moxel.Cell;
import com._1c.g5.v8.dt.moxel.Drawing;
import com._1c.g5.v8.dt.moxel.Row;
import com._1c.g5.v8.dt.moxel.SpreadsheetDocument;
import com._1c.g5.v8.dt.moxel.content.BaseDrawingProperties;
import com._1c.g5.v8.dt.moxel.content.CellReference;
import com._1c.g5.v8.dt.moxel.content.CellsProperties;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.ui.collector.BaseDelegatedSelectionCollector;
import com.e1c.langtool.ui.collector.FeatureValueCollectingResult;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class MoxelPropertiesCollectorDelegate
extends BaseDelegatedSelectionCollector {
    @Inject
    protected MoxelPropertiesCollectorDelegate(ITranslatingProjectManager translatingProjectManager, IFeatureValueCollectingService collectingService, ITranslationStorageManager translationStorageManager) {
        super(translatingProjectManager, collectingService, translationStorageManager);
    }

    public FeatureValueCollectingResult collectSelection(IWorkbenchPart part, ISelection selection, ICollectingParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List<EObject> filtered = this.getModelFromSelection(structuredSelection, monitor);
            for (EObject item : filtered) {
                if (monitor.isCanceled()) {
                    return null;
                }
                TranslationSource source = TranslationUtils.getTranslationSource((Object)item);
                if (source == null) continue;
                return this.collectSource(source, parameters, part, selection, monitor);
            }
        }
        return null;
    }

    private List<EObject> getModelFromSelection(IStructuredSelection selection, IProgressMonitor monitor) {
        ArrayList<EObject> filtered = new ArrayList<EObject>();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Drawing drawing;
            if (monitor.isCanceled()) {
                return filtered;
            }
            Object item = iterator.next();
            if (item instanceof CellsProperties) {
                Cell cell = MoxelPropertiesCollectorDelegate.lookupCell(((CellsProperties)item).getCellReference());
                if (cell == null) continue;
                filtered.add((EObject)cell);
                continue;
            }
            if (!(item instanceof BaseDrawingProperties) || (drawing = MoxelPropertiesCollectorDelegate.lookupDrowing(((BaseDrawingProperties)item).getCellReference())) == null) continue;
            filtered.add((EObject)drawing);
        }
        return filtered;
    }

    private static Cell lookupCell(CellReference ref) {
        if (ref == null || ref.getSpreadsheet() == null) {
            return null;
        }
        SpreadsheetDocument spreadsheet = (SpreadsheetDocument)ref.getSpreadsheet();
        Row row = (Row)spreadsheet.getRows().get((Object)ref.getRowIndex());
        if (row == null) {
            return null;
        }
        return (Cell)row.getCells().get((Object)ref.getColumnIndex());
    }

    private static Drawing lookupDrowing(CellReference ref) {
        if (ref == null || ref.getSpreadsheet() == null) {
            return null;
        }
        SpreadsheetDocument spreadsheet = (SpreadsheetDocument)ref.getSpreadsheet();
        return (Drawing)spreadsheet.getDrawings().get(Integer.valueOf(ref.getRowIndex()).intValue());
    }
}

