/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.selection;

import com._1c.g5.v8.dt.core.platform.IConfigurationAware;
import com._1c.g5.v8.dt.core.platform.IExternalObjectProject;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.navigator.adapters.CollectionNavigatorAdapterBase;
import com._1c.g5.v8.dt.navigator.adapters.NavigatorAdapterBase;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.ui.collector.BaseDelegatedSelectionCollector;
import com.e1c.langtool.ui.collector.FeatureValueCollectingResult;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class NavigatorSelectionCollectorDelegate
extends BaseDelegatedSelectionCollector {
    private final IV8ProjectManager v8ProjectManager;

    @Inject
    public NavigatorSelectionCollectorDelegate(ITranslatingProjectManager translatingProjectManager, IFeatureValueCollectingService collectingService, ITranslationStorageManager translationStorageManager, IV8ProjectManager v8ProjectManager) {
        super(translatingProjectManager, collectingService, translationStorageManager);
        this.v8ProjectManager = v8ProjectManager;
    }

    public FeatureValueCollectingResult collectSelection(IWorkbenchPart part, ISelection selection, ICollectingParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<Object> filtered = new ArrayList<Object>();
            Iterator iterator = ss.iterator();
            while (iterator.hasNext()) {
                Collection external;
                if (monitor.isCanceled()) {
                    return null;
                }
                Object item = iterator.next();
                if (item instanceof CollectionNavigatorAdapterBase) {
                    EObject model = ((CollectionNavigatorAdapterBase)item).getModel(true);
                    if (model == null || filtered.contains(model)) continue;
                    filtered.add(model);
                    continue;
                }
                if (item instanceof NavigatorAdapterBase) {
                    item = ((NavigatorAdapterBase)item).getParent(item);
                }
                if (item instanceof EObject) {
                    if (filtered.contains(item)) continue;
                    filtered.add((EObject)item);
                    continue;
                }
                if (!(item instanceof IProject)) continue;
                IV8Project v8Project = this.v8ProjectManager.getProject((IProject)item);
                if (v8Project instanceof IConfigurationAware) {
                    Configuration config = ((IConfigurationAware)v8Project).getConfiguration();
                    if (config == null || filtered.contains(config)) continue;
                    filtered.add(config);
                    continue;
                }
                if (!(v8Project instanceof IExternalObjectProject) || (external = ((IExternalObjectProject)v8Project).getExternalObjects()).isEmpty()) continue;
                filtered.add((EObject)external.iterator().next());
            }
            for (EObject eObject : filtered) {
                TranslationSource source = TranslationUtils.getTranslationSource((Object)eObject);
                if (source == null) continue;
                return this.collectSource(source, parameters, part, selection, monitor);
            }
        }
        return null;
    }
}

