/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.selection;

import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Label;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessor;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.ui.collector.BaseDelegatedSelectionCollector;
import com.e1c.langtool.ui.collector.FeatureValueCollectingResult;
import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IMarkSelection;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.ide.util.CancelIndicatorProgressMonitor;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XtextEditorSelectionCollectorDelegate
extends BaseDelegatedSelectionCollector {
    private EObjectAtOffsetHelper bslObjectAtOffsetHelper;

    @Inject
    public XtextEditorSelectionCollectorDelegate(ITranslatingProjectManager translatingProjectManager, IFeatureValueCollectingService collectingService, ITranslationStorageManager translationStorageManager) {
        super(translatingProjectManager, collectingService, translationStorageManager);
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
        this.bslObjectAtOffsetHelper = (EObjectAtOffsetHelper)resourceServiceProvider.get(EObjectAtOffsetHelper.class);
    }

    public FeatureValueCollectingResult collectSelection(final IWorkbenchPart part, final ISelection selection, final ICollectingParameters parameters, final IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            return null;
        }
        if (selection instanceof ITextSelection || selection instanceof IMarkSelection) {
            int offset = 0;
            if (selection instanceof ITextSelection) {
                ts = (ITextSelection)selection;
                offset = ts.getOffset();
            } else if (selection instanceof IMarkSelection) {
                ts = (IMarkSelection)selection;
                offset = ts.getOffset();
            }
            XtextEditor target = (XtextEditor)part.getAdapter(XtextEditor.class);
            if (target == null || monitor.isCanceled()) {
                return null;
            }
            final int finalOffset = offset;
            IXtextDocument doc = target.getDocument();
            return (FeatureValueCollectingResult)doc.readOnly((IUnitOfWork)new CancelableUnitOfWork<FeatureValueCollectingResult, XtextResource>(){

                public FeatureValueCollectingResult exec(XtextResource res, CancelIndicator cancelIndicator) throws Exception {
                    if (XtextEditorSelectionCollectorDelegate.this.isCanceled(cancelIndicator, monitor)) {
                        return null;
                    }
                    EObject item = XtextEditorSelectionCollectorDelegate.this.getSelectedItem(res, finalOffset, cancelIndicator, monitor);
                    if (item == null || XtextEditorSelectionCollectorDelegate.this.isCanceled(cancelIndicator, monitor)) {
                        return null;
                    }
                    TranslationSource source = TranslationUtils.getTranslationSource((Object)item);
                    if (source != null && !cancelIndicator.isCanceled()) {
                        CancelIndicatorProgressMonitor subMonitor = new CancelIndicatorProgressMonitor(cancelIndicator);
                        return XtextEditorSelectionCollectorDelegate.this.collectSource(source, parameters, part, selection, (IProgressMonitor)subMonitor);
                    }
                    return null;
                }
            });
        }
        return null;
    }

    private boolean isCanceled(CancelIndicator cancelIndicator, IProgressMonitor monitor) {
        if (cancelIndicator.isCanceled()) {
            monitor.setCanceled(true);
            return true;
        }
        return monitor.isCanceled();
    }

    private EObject getSelectedItem(XtextResource res, int offset, CancelIndicator cancelIndicator, IProgressMonitor monitor) {
        EObject obj;
        if (res.getContents() != null && !res.getContents().isEmpty() && (obj = (EObject)res.getContents().get(0)) instanceof Module) {
            if (this.isCanceled(cancelIndicator, monitor)) {
                return null;
            }
            EObject subObject = this.bslObjectAtOffsetHelper.resolveElementAt(res, offset);
            if (subObject instanceof Variable || subObject instanceof StringLiteral || subObject instanceof RegionPreprocessor || subObject instanceof DynamicFeatureAccess || subObject instanceof Label) {
                return subObject;
            }
            if (subObject != null) {
                EObject e = subObject;
                while (e != null) {
                    if (this.isCanceled(cancelIndicator, monitor)) {
                        return null;
                    }
                    if (e instanceof Method) {
                        return e;
                    }
                    e = e.eContainer();
                }
            }
            return obj;
        }
        return null;
    }
}

