/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.translator.wizard;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.generatestring.TranslationStringsGenerator;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatedProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.ui.generatestring.GenerateSettingsWizardPage;
import com.e1c.langtool.ui.generatestring.GenerateTranslationStringsWizard;
import com.e1c.langtool.v8.dt.V8EmfTranslationSource;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.internal.ui.translator.wizard.BlockerWizardPage;
import com.e1c.langtool.v8.dt.internal.ui.translator.wizard.ImportSettingsWizardPage;
import com.e1c.langtool.v8.dt.internal.ui.translator.wizard.Messages;
import com.e1c.langtool.v8.dt.translator.TranslatedObjectImportTranslationStrings;
import com.e1c.langtool.v8.dt.translator.TranslatedProjectImportTranslationStrings;
import com.e1c.langtool.v8.dt.translator.V8ObjectID;
import com.e1c.langtool.v8.dt.translator.V8ObjectIdProvider;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class TranslatedObjectImportWizard
extends GenerateTranslationStringsWizard
implements IImportWizard {
    @Inject
    private ITranslatedProjectManager translatedProjectManager;
    @Inject
    private V8ObjectIdProvider v8ObjectIdProvider;
    @Inject
    private Provider<TranslatedProjectImportTranslationStrings> translatedProjectImportProvider;
    @Inject
    private Provider<TranslatedObjectImportTranslationStrings> translatedObjectImportProvider;
    @Inject
    private Provider<ImportSettingsWizardPage> settingsPageProvider;
    @Inject
    private Provider<V8EmfTranslationSource> v8EmfTranslationSourcePrivder;
    private String errorMessage = null;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Map<IProject, Collection<TranslationSource>> objects = this.getSelectedObjects(selection);
        for (Map.Entry<IProject, Collection<TranslationSource>> entry : objects.entrySet()) {
            ITranslatedProject translated = this.translatedProjectManager.getProject(entry.getKey());
            if (!translated.isTranslated() || translated.getSourceProject().getProject() == null) continue;
            Collection<TranslationSource> sourceObjects = this.convertToSourceObjects(translated, entry.getValue());
            if (!entry.getValue().isEmpty() && sourceObjects.isEmpty()) {
                V8EmfTranslationSource empty = this.getTranslationSource();
                empty.setObject(EcoreFactory.eINSTANCE.createEObject());
                sourceObjects.add((TranslationSource)empty);
            }
            this.createGenerator(sourceObjects);
            if (this.generator instanceof TranslatedProjectImportTranslationStrings) {
                ((TranslatedProjectImportTranslationStrings)this.generator).setTranslatedProject(translated);
                for (TranslateLanguage language : translated.getInterfaceLanguages()) {
                    this.generator.addLanguage(language);
                }
            }
            this.init(translated.getSourceProject().getProject(), sourceObjects);
            return;
        }
        this.setErrorMessage(Messages.TranslatedObjectImportWizard_Please_select_objects_form_translated_project);
    }

    private Collection<TranslationSource> convertToSourceObjects(ITranslatedProject translated, Collection<TranslationSource> value) {
        ArrayList converted = Lists.newArrayList();
        for (TranslationSource source : value) {
            EObject element;
            TranslationSource original;
            V8ObjectID id;
            if (!(source.getSourceObject() instanceof EObject) || (id = this.v8ObjectIdProvider.getId((EObject)source.getSourceObject())) == null || (original = TranslationUtils.getTranslationSource((Object)(element = this.v8ObjectIdProvider.getObjectOrProxy(translated.getSourceProject().getProject(), id)))) == null) continue;
            converted.add(original);
        }
        return converted;
    }

    public void addPages() {
        if (this.getErrorMessage() != null) {
            this.addPage((IWizardPage)new BlockerWizardPage(Messages.TranslatedObjectImportWizard_Cannot_continue, this.getErrorMessage()));
        } else {
            super.addPages();
        }
    }

    public boolean canFinish() {
        return this.getErrorMessage() == null && super.canFinish();
    }

    public IDialogSettings getDialogSettings() {
        return DialogSettings.getOrCreateSection((IDialogSettings)V8UiPlugin.getDefault().getDialogSettings(), (String)TranslatedObjectImportWizard.class.getName());
    }

    protected void createGenerator(Collection<TranslationSource> projectObjects) {
        if (this.generator != null) {
            return;
        }
        if (projectObjects.isEmpty()) {
            this.generator = (TranslationStringsGenerator)this.translatedProjectImportProvider.get();
        } else {
            this.generator = (TranslationStringsGenerator)this.translatedObjectImportProvider.get();
            ((TranslatedObjectImportTranslationStrings)this.generator).setProjectObjects(projectObjects);
        }
    }

    protected GenerateSettingsWizardPage getSettingsPage() {
        return (GenerateSettingsWizardPage)this.settingsPageProvider.get();
    }

    private Map<IProject, Collection<TranslationSource>> getSelectedObjects(IStructuredSelection selection) {
        HashMap projectSelection = Maps.newHashMap();
        if (selection == null) {
            return projectSelection;
        }
        for (Object element : selection) {
            if (element instanceof IProject) {
                Collection elements = (Collection)projectSelection.get(element);
                if (elements != null) continue;
                projectSelection.put((IProject)element, Lists.newArrayList());
                continue;
            }
            TranslationSource source = TranslationUtils.getTranslationSource(element);
            if (source == null || source.getProject() == null) continue;
            Collection elements = projectSelection.computeIfAbsent(source.getProject(), p -> Lists.newArrayList());
            elements.add(source);
            projectSelection.put(source.getProject(), elements);
        }
        return projectSelection;
    }

    protected V8EmfTranslationSource getTranslationSource() {
        return (V8EmfTranslationSource)this.v8EmfTranslationSourcePrivder.get();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

