/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.languageconverter.wizard;

import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.languageconverter.LanguageConverter;
import com.e1c.langtool.v8.dt.ui.languageconverter.wizard.LanguageConversionSettingsWizardPage;
import com.e1c.langtool.v8.dt.ui.languageconverter.wizard.Messages;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class LanguageConversionWizard
extends Wizard {
    private IProject project;
    private Set<Language> selectedLanguages;
    private AtomicBoolean exportTranslationsToStorage = new AtomicBoolean(true);
    private AtomicReference<StorageID> targetStorageId = new AtomicReference();
    @Inject
    private Provider<LanguageConversionSettingsWizardPage> mainPageProvider;
    @Inject
    private LanguageConverter languageConverter;
    private LanguageConversionSettingsWizardPage mainPage;

    protected LanguageConversionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = (LanguageConversionSettingsWizardPage)((Object)this.mainPageProvider.get());
        this.mainPage.init(this.project, this.selectedLanguages, this.exportTranslationsToStorage, this.targetStorageId);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return this.mainPage.isPageComplete();
    }

    public boolean performFinish() {
        try {
            IProject target = this.getTargetProject();
            this.getContainer().run(true, true, monitor -> this.languageConverter.convertLanguages(this.project, this.selectedLanguages, target, this.exportTranslationsToStorage.get(), this.targetStorageId.get(), monitor));
        }
        catch (InvocationTargetException e) {
            V8UiPlugin.logError(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void init(IProject project, Set<Language> selectedLanguages) {
        this.project = project;
        this.selectedLanguages = selectedLanguages;
        Assert.isNotNull((Object)project, (String)"Project shall not be NULL");
        Assert.isNotNull(selectedLanguages, (String)"Languages set shall not be null");
        this.setWindowTitle(Messages.LanguageConversionWizard_WindowTitle);
    }

    private void addNature(IProject project, String natureId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] prevNatures = desc.getNatureIds();
        boolean isExist = Arrays.stream(prevNatures).anyMatch(natureId::equals);
        if (isExist) {
            return;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        desc.setNatureIds(newNatures);
        project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
    }

    private void addBuilderIfNotExist(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                return;
            }
            ++i;
        }
        ICommand command = desc.newCommand();
        command.setBuilderName(builderId);
        ICommand[] nc = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, nc, 0, commands.length);
        nc[commands.length] = command;
        desc.setBuildSpec(nc);
        project.setDescription(desc, null);
    }

    private IProject getTargetProject() throws InvocationTargetException {
        IProject target = this.mainPage.getTargetProject();
        try {
            if (!target.isAccessible()) {
                URI location = null;
                if (!this.mainPage.useDefaults()) {
                    location = this.mainPage.getLocationURI();
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProjectDescription description = workspace.newProjectDescription(target.getName());
                description.setLocationURI(location);
                IRunnableWithProgress op = monitor -> {
                    try {
                        if (target.exists() && !target.isOpen()) {
                            target.open(monitor);
                        } else if (!target.exists()) {
                            CreateProjectOperation op1 = new CreateProjectOperation(description, Messages.LanguageConversionWizard_Create_new_project);
                            op1.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
                        }
                        if (!this.project.equals((Object)target)) {
                            this.addNature(target, "com.e1c.langtool.v8.dt.resourcestorage.dependentProjectNature");
                            this.addBuilderIfNotExist(target, "com.e1c.langtool.v8.dt.resourcestorage.dependentTranslationBuilder");
                        }
                    }
                    catch (ExecutionException | CoreException e) {
                        V8UiPlugin.logError(e);
                    }
                };
                this.getContainer().run(true, true, op);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return target;
    }
}

