/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.navigator.actions;

import com._1c.g5.v8.dt.common.StringUtils;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.ui.commands.list.AbstractListElementHandler;
import com._1c.g5.v8.dt.ui.util.OpenHelper;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.ui.navigator.actions.Messages;
import com.google.inject.Inject;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenEditorTranslation
extends AbstractListElementHandler {
    private static final String FEATURE_NAME_DELIMITER = "/";
    @Inject
    private OpenHelper helper;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IResourceLookup resourceLookup;

    public Object execute(ExecutionEvent event) {
        EObject objectToOpen = this.getSelectedElement(event);
        if (objectToOpen == null) {
            return null;
        }
        IProject project = this.resourceLookup.getProject(objectToOpen);
        if (project == null) {
            return null;
        }
        @NonNull ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            if (!shell.isDisposed() && !shell.getDisplay().isDisposed()) {
                shell.getDisplay().asyncExec(() -> MessageDialog.openInformation((Shell)shell, (String)Messages.OpenEditorTranslation_Setup_project_for_translation, (String)Messages.OpenEditorTranslation_Convert_existing_languages_or_add_translate_languages_to_setup_project_for_translation));
            }
            return null;
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        FeaturePath featurePath = this.getFeatureParameter(event, objectToOpen);
        boolean useFeature = this.getUseFeatureParameter(event);
        IEditorInput input = null;
        if (featurePath != null && useFeature) {
            EStructuralFeature[] features = featurePath.getFeaturePath();
            int index = 0;
            index = 0;
            while (index < features.length) {
                objectToOpen = (EObject)objectToOpen.eGet(features[index]);
                ++index;
            }
            input = this.helper.getEditorInput(objectToOpen, null, null);
        } else if (objectToOpen != null) {
            input = this.helper.getEditorInput(objectToOpen, null, null);
        }
        if (input != null) {
            try {
                page.openEditor(input, "com.e1c.langtool.ui.editor.TranslationEditor", true);
            }
            catch (PartInitException e) {
                V8UiPlugin.logError(e);
            }
        }
        return null;
    }

    protected FeaturePath getFeatureParameter(ExecutionEvent event, EObject eObject) {
        String[] featuresName = this.getFeaturesNameParameter(event);
        if (featuresName == null || featuresName.length == 0) {
            return null;
        }
        EStructuralFeature[] features = new EStructuralFeature[featuresName.length];
        EObject current = eObject;
        int i = 0;
        while (i < featuresName.length) {
            String featureName = featuresName[i];
            EStructuralFeature feature = current.eClass().getEStructuralFeature(StringUtils.uncapitalize((String)featureName));
            if (feature == null) {
                return null;
            }
            features[i] = feature;
            if (i < featuresName.length - 1) {
                Object obj = current.eGet(feature);
                if (obj instanceof EObject) {
                    current = (EObject)obj;
                } else {
                    throw new IllegalStateException("Feature with a type different from EObject can only be the last");
                }
            }
            ++i;
        }
        return FeaturePath.fromList((EStructuralFeature[])features);
    }

    private String[] getFeaturesNameParameter(ExecutionEvent event) {
        String feature = event.getParameter("com._1c.g5.v8.dt.ui.commandParemeters.feature");
        return feature == null ? null : feature.split(FEATURE_NAME_DELIMITER);
    }

    private boolean getUseFeatureParameter(ExecutionEvent event) {
        String param = event.getParameter("com._1c.g5.v8.dt.ui.commandParameters.useFeature");
        return Boolean.parseBoolean(param);
    }
}

